/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.annotation.DoubleInRange;
import com.code_intelligence.jazzer.mutation.annotation.FloatInRange;
import com.code_intelligence.jazzer.mutation.annotation.InRange;
import com.code_intelligence.jazzer.mutation.annotation.WithLength;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.lang.FloatingPointMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.lang.IntegralMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.libfuzzer.LibFuzzerMutatorFactory;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

final class PrimitiveArrayMutatorFactory
implements MutatorFactory {
    PrimitiveArrayMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        Optional<Class<?>> clazz = TypeSupport.findFirstParentIfClass(type, byte[].class, int[].class, long[].class, short[].class, char[].class, float[].class, double[].class, boolean[].class);
        return clazz.map(aClass -> new PrimitiveArrayMutator(type));
    }

    public static final class PrimitiveArrayMutator<T>
    extends SerializingMutator<T> {
        private static final int DEFAULT_MIN_LENGTH = 0;
        private static final int DEFAULT_MAX_LENGTH = 1000;
        private long minRange;
        private long maxRange;
        private boolean allowNaN;
        private float minFloatRange;
        private float maxFloatRange;
        private double minDoubleRange;
        private double maxDoubleRange;
        private final AnnotatedType elementType;
        private final SerializingMutator<byte[]> innerMutator;
        private final Function<byte[], T> toPrimitive;
        private final Function<T, byte[]> toBytes;

        public PrimitiveArrayMutator(AnnotatedType type) {
            this.elementType = ((AnnotatedArrayType)type).getAnnotatedGenericComponentType();
            this.extractRange(this.elementType);
            AnnotatedType innerByteArray = TypeSupport.forwardAnnotations(type, PrimitiveArrayMutator.convertWithLength(type, new TypeHolder<byte[]>(){}.annotatedType()));
            this.innerMutator = LibFuzzerMutatorFactory.tryCreate(innerByteArray).get();
            this.toPrimitive = this.makeBytesToPrimitiveArrayConverter(this.elementType);
            this.toBytes = PrimitiveArrayMutator.makePrimitiveArrayToBytesConverter(this.elementType);
        }

        @Override
        public boolean hasFixedSize() {
            return false;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return this.elementType.getType() + "[]";
        }

        @Override
        public T detach(T value) {
            return value;
        }

        @Override
        public T read(DataInputStream in) throws IOException {
            return this.toPrimitive.apply((byte[])this.innerMutator.read(in));
        }

        @Override
        public void write(T value, DataOutputStream out) throws IOException {
            this.innerMutator.write(this.toBytes.apply(value), out);
        }

        @Override
        public T init(PseudoRandom prng) {
            return this.toPrimitive.apply((byte[])this.innerMutator.init(prng));
        }

        @Override
        public T mutate(T value, PseudoRandom prng) {
            return this.toPrimitive.apply(this.innerMutator.mutate(this.toBytes.apply(value), prng));
        }

        @Override
        public T crossOver(T value, T otherValue, PseudoRandom prng) {
            return this.toPrimitive.apply(this.innerMutator.crossOver(this.toBytes.apply(value), this.toBytes.apply(otherValue), prng));
        }

        private void extractRange(AnnotatedType type) {
            Optional<InRange> inRange = Optional.ofNullable(type.getAnnotation(InRange.class));
            Optional<FloatInRange> inRangeFloat = Optional.ofNullable(type.getAnnotation(FloatInRange.class));
            Optional<DoubleInRange> inRangeDouble = Optional.ofNullable(type.getAnnotation(DoubleInRange.class));
            switch (type.getType().getTypeName()) {
                case "int": {
                    this.minRange = inRange.map(InRange::min).orElse((Long)Integer.MIN_VALUE);
                    this.maxRange = inRange.map(InRange::max).orElse((Long)Integer.MAX_VALUE);
                    break;
                }
                case "long": {
                    this.minRange = inRange.map(InRange::min).orElse(Long.MIN_VALUE);
                    this.maxRange = inRange.map(InRange::max).orElse(Long.MAX_VALUE);
                    break;
                }
                case "short": {
                    this.minRange = inRange.map(InRange::min).orElse(-32768L);
                    this.maxRange = inRange.map(InRange::max).orElse(32767L);
                    break;
                }
                case "char": {
                    this.minRange = inRange.map(InRange::min).orElse(0L);
                    this.maxRange = inRange.map(InRange::max).orElse(65535L);
                    break;
                }
                case "float": {
                    this.minFloatRange = inRangeFloat.map(FloatInRange::min).orElse(Float.valueOf(Float.NEGATIVE_INFINITY)).floatValue();
                    this.maxFloatRange = inRangeFloat.map(FloatInRange::max).orElse(Float.valueOf(Float.POSITIVE_INFINITY)).floatValue();
                    this.allowNaN = inRangeFloat.map(FloatInRange::allowNaN).orElse(false);
                    break;
                }
                case "double": {
                    this.minDoubleRange = inRangeDouble.map(DoubleInRange::min).orElse(Double.NEGATIVE_INFINITY);
                    this.maxDoubleRange = inRangeDouble.map(DoubleInRange::max).orElse(Double.POSITIVE_INFINITY);
                    this.allowNaN = inRangeDouble.map(DoubleInRange::allowNaN).orElse(false);
                    break;
                }
                case "boolean": {
                    this.minRange = inRange.map(InRange::min).orElse(0L);
                    this.maxRange = inRange.map(InRange::max).orElse(1L);
                    break;
                }
                case "byte": {
                    this.minRange = inRange.map(InRange::min).orElse(-128L);
                    this.maxRange = inRange.map(InRange::max).orElse(127L);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected type: " + type);
                }
            }
        }

        private static AnnotatedType convertWithLength(AnnotatedType type, AnnotatedType newType) {
            AnnotatedType elementType = ((AnnotatedArrayType)type).getAnnotatedGenericComponentType();
            Optional<WithLength> withLength = Optional.ofNullable(type.getAnnotation(WithLength.class));
            int minLength = withLength.map(WithLength::min).orElse(0);
            int maxLength = withLength.map(WithLength::max).orElse(1000);
            switch (elementType.getType().getTypeName()) {
                case "int": 
                case "float": {
                    return TypeSupport.withLength(newType, minLength * 4, maxLength * 4);
                }
                case "long": 
                case "double": {
                    return TypeSupport.withLength(newType, minLength * 8, maxLength * 8);
                }
                case "short": 
                case "char": {
                    return TypeSupport.withLength(newType, minLength * 2, maxLength * 2);
                }
                case "boolean": 
                case "byte": {
                    return TypeSupport.withLength(newType, minLength, maxLength);
                }
            }
            throw new IllegalStateException("Unexpected value: " + elementType);
        }

        private Function<byte[], ?> makeBytesToPrimitiveArrayConverter(AnnotatedType type) {
            switch (type.getType().getTypeName()) {
                case "int": {
                    return PrimitiveArrayMutator.getIntegerPrimitiveArray(this.minRange, this.maxRange);
                }
                case "long": {
                    return PrimitiveArrayMutator.getLongPrimitiveArray(this.minRange, this.maxRange);
                }
                case "short": {
                    return PrimitiveArrayMutator.getShortPrimitiveArray(this.minRange, this.maxRange);
                }
                case "char": {
                    return PrimitiveArrayMutator.getCharPrimitiveArray(this.minRange, this.maxRange);
                }
                case "float": {
                    return PrimitiveArrayMutator.getFloatPrimitiveArray(this.minFloatRange, this.maxFloatRange, this.allowNaN);
                }
                case "double": {
                    return PrimitiveArrayMutator.getDoublePrimitiveArray(this.minDoubleRange, this.maxDoubleRange, this.allowNaN);
                }
                case "boolean": {
                    return PrimitiveArrayMutator.getBooleanPrimitiveArray(this.minRange, this.maxRange);
                }
                case "byte": {
                    return PrimitiveArrayMutator.getBytePrimitiveArray(this.minRange, this.maxRange);
                }
            }
            throw new IllegalStateException("Unexpected value: " + type);
        }

        public static Function<?, byte[]> makePrimitiveArrayToBytesConverter(AnnotatedType type) {
            switch (type.getType().getTypeName()) {
                case "int": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((int[])array).length * 4);
                        buffer.asIntBuffer().put((int[])array);
                        return buffer.array();
                    };
                }
                case "long": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((long[])array).length * 8);
                        buffer.asLongBuffer().put((long[])array);
                        return buffer.array();
                    };
                }
                case "short": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((short[])array).length * 2);
                        buffer.asShortBuffer().put((short[])array);
                        return buffer.array();
                    };
                }
                case "char": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((char[])array).length * 2);
                        buffer.asCharBuffer().put((char[])array);
                        return buffer.array();
                    };
                }
                case "float": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((float[])array).length * 4);
                        buffer.asFloatBuffer().put((float[])array);
                        return buffer.array();
                    };
                }
                case "double": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(((double[])array).length * 8);
                        buffer.asDoubleBuffer().put((double[])array);
                        return buffer.array();
                    };
                }
                case "boolean": {
                    return array -> {
                        if (array == null) {
                            return null;
                        }
                        byte[] buffer = new byte[((boolean[])array).length];
                        for (int i = 0; i < ((boolean[])array).length; ++i) {
                            buffer[i] = (byte)(array[i] ? 1 : 0);
                        }
                        return buffer;
                    };
                }
                case "byte": {
                    return array -> array;
                }
            }
            throw new IllegalStateException("Unexpected value: " + type);
        }

        public static Function<byte[], int[]> getIntegerPrimitiveArray(long minRange, long maxRange) {
            int nBytes = 4;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                int extraBytes = ((byte[])byteArray).length % nBytes;
                int[] result = new int[((byte[])byteArray).length / nBytes + (extraBytes > 0 ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = (int)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(buffer.getInt(), minRange, maxRange);
                }
                if (extraBytes > 0) {
                    i = 0;
                    while (buffer.hasRemaining()) {
                        int n = result.length - 1;
                        result[n] = result[n] | (buffer.get() & 0xFF) << 8 * (extraBytes - 1 - i);
                        ++i;
                    }
                    result[result.length - 1] = (int)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(result[result.length - 1], minRange, maxRange);
                }
                return result;
            };
        }

        public static Function<byte[], long[]> getLongPrimitiveArray(long minRange, long maxRange) {
            int nBytes = 8;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                long extraBytes = ((byte[])byteArray).length % nBytes;
                long[] result = new long[((byte[])byteArray).length / nBytes + (extraBytes > 0L ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(buffer.getLong(), minRange, maxRange);
                }
                if (extraBytes > 0L) {
                    i = 0;
                    while (buffer.hasRemaining()) {
                        int n = result.length - 1;
                        result[n] = result[n] | (long)(buffer.get() & 0xFF) << (int)(8L * (extraBytes - 1L - (long)i));
                        ++i;
                    }
                    result[result.length - 1] = IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(result[result.length - 1], minRange, maxRange);
                }
                return result;
            };
        }

        public static Function<byte[], short[]> getShortPrimitiveArray(long minRange, long maxRange) {
            int nBytes = 2;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                short extraBytes = (short)(((byte[])byteArray).length % nBytes);
                short[] result = new short[((byte[])byteArray).length / nBytes + (extraBytes > 0 ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = (short)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(buffer.getShort(), minRange, maxRange);
                }
                if (extraBytes > 0) {
                    i = 0;
                    while (buffer.hasRemaining()) {
                        int n = result.length - 1;
                        result[n] = (short)(result[n] | (short)((buffer.get() & 0xFF) << 8 * (extraBytes - 1 - i)));
                        ++i;
                    }
                    result[result.length - 1] = (short)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(result[result.length - 1], minRange, maxRange);
                }
                return result;
            };
        }

        public static Function<byte[], char[]> getCharPrimitiveArray(long minRange, long maxRange) {
            int nBytes = 2;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                char extraBytes = (char)(((byte[])byteArray).length % nBytes);
                char[] result = new char[((byte[])byteArray).length / nBytes + (extraBytes > '\u0000' ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = (char)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(buffer.getChar(), minRange, maxRange);
                }
                if (extraBytes > '\u0000') {
                    i = 0;
                    while (buffer.hasRemaining()) {
                        int n = result.length - 1;
                        result[n] = (char)(result[n] | (char)((buffer.get() & 0xFF) << 8 * (extraBytes - '\u0001' - i)));
                        ++i;
                    }
                    result[result.length - 1] = (char)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(result[result.length - 1], minRange, maxRange);
                }
                return result;
            };
        }

        public static Function<byte[], float[]> getFloatPrimitiveArray(float minFloatRange, float maxFloatRange, boolean allowNaN) {
            int nBytes = 4;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                int extraBytes = ((byte[])byteArray).length % nBytes;
                float[] result = new float[((byte[])byteArray).length / nBytes + (extraBytes > 0 ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = FloatingPointMutatorFactory.FloatMutator.forceInRange(buffer.getFloat(), minFloatRange, maxFloatRange, allowNaN);
                }
                if (extraBytes > 0) {
                    i = 0;
                    int lastNumber = 0;
                    while (buffer.hasRemaining()) {
                        lastNumber |= (buffer.get() & 0xFF) << 8 * (extraBytes - 1 - i);
                        ++i;
                    }
                    result[result.length - 1] = FloatingPointMutatorFactory.FloatMutator.forceInRange(Float.intBitsToFloat(lastNumber), minFloatRange, maxFloatRange, allowNaN);
                }
                return result;
            };
        }

        public static Function<byte[], double[]> getDoublePrimitiveArray(double minDoubleRange, double maxDoubleRange, boolean allowNaN) {
            int nBytes = 8;
            return byteArray -> {
                int i;
                if (byteArray == null) {
                    return null;
                }
                int extraBytes = ((byte[])byteArray).length % nBytes;
                double[] result = new double[((byte[])byteArray).length / nBytes + (extraBytes > 0 ? 1 : 0)];
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                for (i = 0; i < ((byte[])byteArray).length / nBytes; ++i) {
                    result[i] = FloatingPointMutatorFactory.DoubleMutator.forceInRange(buffer.getDouble(), minDoubleRange, maxDoubleRange, allowNaN);
                }
                if (extraBytes > 0) {
                    i = 0;
                    long lastNumber = 0L;
                    while (buffer.hasRemaining()) {
                        lastNumber |= (long)(buffer.get() & 0xFF) << 8 * (extraBytes - 1 - i);
                        ++i;
                    }
                    result[result.length - 1] = FloatingPointMutatorFactory.DoubleMutator.forceInRange(Double.longBitsToDouble(lastNumber), minDoubleRange, maxDoubleRange, allowNaN);
                }
                return result;
            };
        }

        public static Function<byte[], boolean[]> getBooleanPrimitiveArray(long minRange, long maxRange) {
            return byteArray -> {
                if (byteArray == null) {
                    return null;
                }
                boolean[] result = new boolean[((byte[])byteArray).length];
                for (int i = 0; i < ((byte[])byteArray).length; ++i) {
                    result[i] = IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(byteArray[i], minRange, maxRange) == 1L;
                }
                return result;
            };
        }

        public static Function<byte[], byte[]> getBytePrimitiveArray(long minRange, long maxRange) {
            return byteArray -> {
                if (byteArray == null) {
                    return null;
                }
                byte[] result = new byte[((byte[])byteArray).length];
                for (int i = 0; i < ((byte[])byteArray).length; ++i) {
                    result[i] = (byte)IntegralMutatorFactory.AbstractIntegralMutator.forceInRange(byteArray[i], minRange, maxRange);
                }
                return result;
            };
        }
    }
}

