/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class BuilderAdapters {
    private BuilderAdapters() {
    }

    static <T extends Message.Builder, U> List<U> makeMutableRepeatedFieldView(final T builder, final Descriptors.FieldDescriptor field) {
        return new AbstractList<U>(){

            @Override
            public U get(int index) {
                return builder.getRepeatedField(field, index);
            }

            @Override
            public int size() {
                return builder.getRepeatedFieldCount(field);
            }

            @Override
            public boolean add(U element) {
                builder.addRepeatedField(field, element);
                return true;
            }

            @Override
            public void add(int index, U element) {
                this.addAll(index, Collections.singletonList(element));
            }

            @Override
            public boolean addAll(int index, Collection<? extends U> other) {
                int i;
                int otherSize = other.size();
                if (otherSize == 0) {
                    return false;
                }
                int originalSize = this.size();
                if (index == originalSize) {
                    for (Object element : other) {
                        builder.addRepeatedField(field, element);
                    }
                    return true;
                }
                int newSize = originalSize + otherSize;
                ArrayList<Object> temp = new ArrayList<Object>(newSize);
                for (i = 0; i < index; ++i) {
                    temp.add(builder.getRepeatedField(field, i));
                }
                temp.addAll(other);
                for (i = index; i < originalSize; ++i) {
                    temp.add(builder.getRepeatedField(field, i));
                }
                this.replaceWith(temp);
                return true;
            }

            @Override
            public U set(int index, U element) {
                Object previous = this.get(index);
                builder.setRepeatedField(field, index, element);
                return previous;
            }

            @Override
            public U remove(int index) {
                Object removed = this.get(index);
                this.removeRange(index, index + 1);
                return removed;
            }

            @Override
            protected void removeRange(int fromIndex, int toIndex) {
                int i;
                int originalSize = this.size();
                int newSize = originalSize - (toIndex - fromIndex);
                if (newSize == 0) {
                    builder.clearField(field);
                    return;
                }
                ArrayList<Object> temp = new ArrayList<Object>(newSize);
                for (i = 0; i < fromIndex; ++i) {
                    temp.add(builder.getRepeatedField(field, i));
                }
                for (i = toIndex; i < originalSize; ++i) {
                    temp.add(builder.getRepeatedField(field, i));
                }
                this.replaceWith(temp);
            }

            private void replaceWith(ArrayList<U> temp) {
                builder.clearField(field);
                for (Object element : temp) {
                    builder.addRepeatedField(field, element);
                }
            }
        };
    }

    static <T extends Message.Builder, U> U getPresentFieldOrNull(T builder, Descriptors.FieldDescriptor field) {
        if (builder.hasField(field)) {
            return (U)builder.getField(field);
        }
        return null;
    }

    static <T extends Message.Builder, U> void setFieldWithPresence(T builder, Descriptors.FieldDescriptor field, U value) {
        if (value == null) {
            builder.clearField(field);
        } else {
            builder.setField(field, value);
        }
    }

    static <T extends Message.Builder, K, V> Map<K, V> getMapField(T builder, Descriptors.FieldDescriptor field) {
        int size = builder.getRepeatedFieldCount(field);
        Descriptors.FieldDescriptor keyField = (Descriptors.FieldDescriptor)field.getMessageType().getFields().get(0);
        Descriptors.FieldDescriptor valueField = (Descriptors.FieldDescriptor)field.getMessageType().getFields().get(1);
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Message entry = (Message)builder.getRepeatedField(field, i);
            map.put(entry.getField(keyField), entry.getField(valueField));
        }
        return map;
    }

    static <T extends Message.Builder, K, V> void setMapField(Message.Builder builder, Descriptors.FieldDescriptor field, Map<K, V> map) {
        builder.clearField(field);
        Descriptors.FieldDescriptor keyField = (Descriptors.FieldDescriptor)field.getMessageType().getFields().get(0);
        Descriptors.FieldDescriptor valueField = (Descriptors.FieldDescriptor)field.getMessageType().getFields().get(1);
        Message.Builder entryBuilder = builder.newBuilderForField(field);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entryBuilder.setField(keyField, entry.getKey());
            entryBuilder.setField(valueField, entry.getValue());
            builder.addRepeatedField(field, (Object)entryBuilder.build());
        }
    }
}

