/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.utils;

import java.io.PrintStream;

public class Log {
    private static PrintStream fixedOut;
    private static PrintStream fixedErr;
    private static final boolean isDebug;

    public static void fixOutErr(PrintStream out, PrintStream err) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        if (err == null) {
            throw new IllegalArgumentException("err must not be null");
        }
        fixedOut = out;
        fixedErr = err;
    }

    public static void println(String message) {
        Log.getErr().println(message);
    }

    public static void structuredOutput(String output) {
        Log.getOut().println(output);
    }

    public static void debug(String message) {
        if (isDebug) {
            Log.println("DEBUG: ", message, null);
        }
    }

    public static void info(String message) {
        Log.println("INFO: ", message, null);
    }

    public static void warn(String message) {
        Log.warn(message, null);
    }

    public static void warn(String message, Throwable t) {
        Log.println("WARN: ", message, t);
    }

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(Throwable t) {
        Log.error(null, t);
    }

    public static void error(String message, Throwable t) {
        Log.println("ERROR: ", message, t);
    }

    public static void finding(Throwable t) {
        Log.println("\n== Java Exception: ", null, t);
    }

    private static void println(String prefix, String message, Throwable t) {
        PrintStream err = Log.getErr();
        err.print(prefix);
        if (message != null) {
            err.println(message + (t != null ? ":" : ""));
        }
        if (t != null) {
            t.printStackTrace(err);
        }
    }

    private static PrintStream getOut() {
        return fixedOut != null ? fixedOut : System.out;
    }

    private static PrintStream getErr() {
        return fixedErr != null ? fixedErr : System.err;
    }

    static {
        isDebug = System.getenv("JAZZER_DEBUG") != null;
    }
}

