/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.utils;

import com.code_intelligence.jazzer.third_party.kotlin.Metadata;
import com.code_intelligence.jazzer.third_party.kotlin.collections.CollectionsKt;
import com.code_intelligence.jazzer.third_party.kotlin.io.CloseableKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.JvmStatic;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.functions.Function1;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.sequences.SequencesKt;
import com.code_intelligence.jazzer.utils.Log;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/code_intelligence/jazzer/utils/ManifestUtils;", "", "()V", "FUZZ_TARGET_CLASS", "", "HOOK_CLASSES", "combineManifestValues", "", "attribute", "detectFuzzTargetClass", "src_main_java_com_code_intelligence_jazzer_utils-manifest_utils"})
public final class ManifestUtils {
    @NotNull
    public static final ManifestUtils INSTANCE = new ManifestUtils();
    @NotNull
    private static final String FUZZ_TARGET_CLASS = "Jazzer-Fuzz-Target-Class";
    @NotNull
    public static final String HOOK_CLASSES = "Jazzer-Hook-Classes";

    private ManifestUtils() {
    }

    @NotNull
    public final List<String> combineManifestValues(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        Enumeration<URL> manifests = ManifestUtils.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNull(manifests);
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.asSequence(CollectionsKt.iterator(manifests)), (Function1)new Function1<URL, String>(attribute){
            final /* synthetic */ String $attribute;
            {
                this.$attribute = $attribute;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final String invoke(URL url) {
                String string;
                Closeable closeable = url.openStream();
                String string2 = this.$attribute;
                Throwable throwable = null;
                try {
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl = false;
                    Manifest manifest = new Manifest(inputStream);
                    string = manifest.getMainAttributes().getValue(string2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return string;
            }
        }));
    }

    @JvmStatic
    @Nullable
    public static final String detectFuzzTargetClass() {
        String string;
        List<String> fuzzTargets = INSTANCE.combineManifestValues(FUZZ_TARGET_CLASS);
        switch (fuzzTargets.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = CollectionsKt.first(fuzzTargets);
                break;
            }
            default: {
                Log.warn("More than one Jazzer-Fuzz-Target-Class manifest entry detected on the classpath.");
                string = null;
            }
        }
        return string;
    }
}

