/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.calendardatepicker;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.format.DateUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.codetroopers.betterpickers.HapticFeedbackController;
import com.codetroopers.betterpickers.OnDialogDismissListener;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.Utils;
import com.codetroopers.betterpickers.calendardatepicker.AccessibleDateAnimator;
import com.codetroopers.betterpickers.calendardatepicker.CalendarDatePickerController;
import com.codetroopers.betterpickers.calendardatepicker.DayPickerView;
import com.codetroopers.betterpickers.calendardatepicker.MonthAdapter;
import com.codetroopers.betterpickers.calendardatepicker.SimpleDayPickerView;
import com.codetroopers.betterpickers.calendardatepicker.YearPickerView;
import com.nineoldandroids.animation.ObjectAnimator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class CalendarDatePickerDialogFragment
extends DialogFragment
implements View.OnClickListener,
CalendarDatePickerController {
    private static final String TAG = "DatePickerDialog";
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_DATE_START = "date_start";
    private static final String KEY_DATE_END = "date_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final String KEY_THEME = "theme";
    private static final String KEY_DISABLED_DAYS = "disabled_days";
    private static final MonthAdapter.CalendarDay DEFAULT_START_DATE = new MonthAdapter.CalendarDay(1900, 0, 1);
    private static final MonthAdapter.CalendarDay DEFAULT_END_DATE = new MonthAdapter.CalendarDay(2100, 11, 31);
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private final Calendar mCalendar = Calendar.getInstance();
    private OnDateSetListener mCallBack;
    private OnDialogDismissListener mDimissCallback;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private AccessibleDateAnimator mAnimator;
    private LinearLayout mSelectedDateLayout;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthAndDayView;
    private TextView mSelectedMonthTextView;
    private TextView mSelectedDayTextView;
    private TextView mYearView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private MonthAdapter.CalendarDay mMinDate = DEFAULT_START_DATE;
    private MonthAdapter.CalendarDay mMaxDate = DEFAULT_END_DATE;
    private String mDoneText;
    private String mCancelText;
    private SparseArray<MonthAdapter.CalendarDay> mDisabledDays;
    private HapticFeedbackController mHapticFeedbackController;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private int mStyleResId = R.style.BetterPickersRadialTimePickerDialog_PrimaryColor;
    private int mSelectedColor;
    private int mUnselectedColor;

    public boolean isThemeDark() {
        return this.mStyleResId == R.style.BetterPickersRadialTimePickerDialog_Dark;
    }

    public CalendarDatePickerDialogFragment setThemeDark() {
        this.mStyleResId = R.style.BetterPickersRadialTimePickerDialog_Dark;
        return this;
    }

    public CalendarDatePickerDialogFragment setThemeLight() {
        this.mStyleResId = R.style.BetterPickersRadialTimePickerDialog_Light;
        return this;
    }

    public CalendarDatePickerDialogFragment setThemeCustom(int styleResId) {
        this.mStyleResId = styleResId;
        return this;
    }

    public CalendarDatePickerDialogFragment setPreselectedDate(int year, int monthOfYear, int dayOfMonth) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
        return this;
    }

    public CalendarDatePickerDialogFragment setDoneText(String text) {
        this.mDoneText = text;
        return this;
    }

    public CalendarDatePickerDialogFragment setCancelText(String text) {
        this.mCancelText = text;
        return this;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putLong(KEY_DATE_START, this.mMinDate.getDateInMillis());
        outState.putLong(KEY_DATE_END, this.mMaxDate.getDateInMillis());
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        outState.putInt(KEY_THEME, this.mStyleResId);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
        outState.putSparseParcelableArray(KEY_DISABLED_DAYS, this.mDisabledDays);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"onCreateView: ");
        if (this.getShowsDialog()) {
            this.getDialog().getWindow().requestFeature(1);
        }
        View view = inflater.inflate(R.layout.calendar_date_picker_dialog, container, false);
        this.mSelectedDateLayout = (LinearLayout)view.findViewById(R.id.day_picker_selected_date_layout);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = 0;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mMinDate = new MonthAdapter.CalendarDay(savedInstanceState.getLong(KEY_DATE_START));
            this.mMaxDate = new MonthAdapter.CalendarDay(savedInstanceState.getLong(KEY_DATE_END));
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
            this.mStyleResId = savedInstanceState.getInt(KEY_THEME);
            this.mDisabledDays = savedInstanceState.getSparseParcelableArray(KEY_DISABLED_DAYS);
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new SimpleDayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        Resources res = this.getResources();
        TypedArray themeColors = this.getActivity().obtainStyledAttributes(this.mStyleResId, R.styleable.BetterPickersDialogs);
        this.mDayPickerDescription = res.getString(R.string.day_picker_description);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mYearPickerDescription = res.getString(R.string.year_picker_description);
        this.mSelectYear = res.getString(R.string.select_year);
        int headerBackgroundColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpHeaderBackgroundColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpWhite));
        int preHeaderBackgroundColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpPreHeaderBackgroundColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpWhite));
        int bodyBgColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpBodyBackgroundColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpWhite));
        int buttonBgColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpButtonsBackgroundColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpWhite));
        int buttonTextColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpButtonsTextColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpBlue));
        this.mSelectedColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpHeaderSelectedTextColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bpWhite));
        this.mUnselectedColor = themeColors.getColor(R.styleable.BetterPickersDialogs_bpHeaderUnselectedTextColor, ContextCompat.getColor((Context)this.getActivity(), (int)R.color.radial_gray_light));
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        if (this.mDoneText != null) {
            doneButton.setText((CharSequence)this.mDoneText);
        }
        doneButton.setTextColor(buttonTextColor);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CalendarDatePickerDialogFragment.this.tryVibrate();
                if (CalendarDatePickerDialogFragment.this.mCallBack != null) {
                    CalendarDatePickerDialogFragment.this.mCallBack.onDateSet(CalendarDatePickerDialogFragment.this, CalendarDatePickerDialogFragment.this.mCalendar.get(1), CalendarDatePickerDialogFragment.this.mCalendar.get(2), CalendarDatePickerDialogFragment.this.mCalendar.get(5));
                }
                CalendarDatePickerDialogFragment.this.dismiss();
            }
        });
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        if (this.mCancelText != null) {
            cancelButton.setText((CharSequence)this.mCancelText);
        }
        cancelButton.setTextColor(buttonTextColor);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CalendarDatePickerDialogFragment.this.tryVibrate();
                CalendarDatePickerDialogFragment.this.dismiss();
            }
        });
        view.findViewById(R.id.ok_cancel_buttons_layout).setBackgroundColor(buttonBgColor);
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        this.mDayPickerView.setTheme(themeColors);
        this.mYearPickerView.setTheme(themeColors);
        this.mSelectedDateLayout.setBackgroundColor(headerBackgroundColor);
        this.mYearView.setBackgroundColor(headerBackgroundColor);
        this.mMonthAndDayView.setBackgroundColor(headerBackgroundColor);
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setBackgroundColor(preHeaderBackgroundColor);
        }
        view.setBackgroundColor(bodyBgColor);
        this.mYearPickerView.setBackgroundColor(bodyBgColor);
        this.mDayPickerView.setBackgroundColor(bodyBgColor);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mSelectedDayTextView.setTextColor(this.mSelectedColor);
                    this.mSelectedMonthTextView.setTextColor(this.mSelectedColor);
                    this.mYearView.setTextColor(this.mUnselectedColor);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                int flags = 16;
                String dayString = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mSelectedDayTextView.setTextColor(this.mUnselectedColor);
                    this.mSelectedMonthTextView.setTextColor(this.mUnselectedColor);
                    this.mYearView.setTextColor(this.mSelectedColor);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String yearString = YEAR_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.mCalendar.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mMonthAndDayView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    public CalendarDatePickerDialogFragment setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
        return this;
    }

    public CalendarDatePickerDialogFragment setDateRange(@Nullable MonthAdapter.CalendarDay startDate, @Nullable MonthAdapter.CalendarDay endDate) {
        this.mMinDate = startDate == null ? DEFAULT_START_DATE : startDate;
        this.mMaxDate = endDate == null ? DEFAULT_END_DATE : endDate;
        if (this.mMaxDate.compareTo(this.mMinDate) < 0) {
            throw new IllegalArgumentException("End date must be larger than start date");
        }
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
        return this;
    }

    public CalendarDatePickerDialogFragment setDisabledDays(@NonNull SparseArray<MonthAdapter.CalendarDay> disabledDays) {
        this.mDisabledDays = disabledDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
        return this;
    }

    public CalendarDatePickerDialogFragment setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
        return this;
    }

    public CalendarDatePickerDialogFragment setOnDismissListener(OnDialogDismissListener ondialogdismisslistener) {
        this.mDimissCallback = ondialogdismisslistener;
        return this;
    }

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCalendar.get(5);
        if (day > (daysInMonth = Utils.getDaysInMonth(month, year))) {
            this.mCalendar.set(5, daysInMonth);
        }
    }

    public void onDismiss(DialogInterface dialoginterface) {
        super.onDismiss(dialoginterface);
        if (this.mDimissCallback != null) {
            this.mDimissCallback.onDialogDismiss(dialoginterface);
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentView(0);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar.get(2), year);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
    }

    private void updatePickers() {
        Iterator<OnDateChangedListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDateChanged();
        }
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        return new MonthAdapter.CalendarDay(this.mCalendar);
    }

    @Override
    public MonthAdapter.CalendarDay getMinDate() {
        return this.mMinDate;
    }

    @Override
    public MonthAdapter.CalendarDay getMaxDate() {
        return this.mMaxDate;
    }

    @Override
    public SparseArray<MonthAdapter.CalendarDay> getDisabledDays() {
        return this.mDisabledDays;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        this.mHapticFeedbackController.tryVibrate();
    }

    public static interface OnDateChangedListener {
        public void onDateChanged();
    }

    public static interface OnDateSetListener {
        public void onDateSet(CalendarDatePickerDialogFragment var1, int var2, int var3, int var4);
    }
}

