/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.datepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.datepicker.DateView;
import com.codetroopers.betterpickers.widget.UnderlinePageIndicatorPicker;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DatePicker
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    protected int mDateInputSize = 2;
    protected int mYearInputSize = 4;
    protected int mMonthInput = -1;
    protected int[] mDateInput = new int[this.mDateInputSize];
    protected int[] mYearInput = new int[this.mYearInputSize];
    protected int mDateInputPointer = -1;
    protected int mYearInputPointer = -1;
    protected final Button[] mMonths = new Button[12];
    protected final Button[] mDateNumbers = new Button[10];
    protected final Button[] mYearNumbers = new Button[10];
    protected Button mDateLeft;
    protected Button mYearLeft;
    protected Button mYearRight;
    protected ImageButton mDateRight;
    protected UnderlinePageIndicatorPicker mKeyboardIndicator;
    protected ViewPager mKeyboardPager;
    protected KeyboardPagerAdapter mKeyboardPagerAdapter;
    protected ImageButton mDelete;
    protected DateView mEnteredDate;
    protected String[] mMonthAbbreviations;
    protected final Context mContext;
    private char[] mDateFormatOrder;
    private static final String KEYBOARD_MONTH = "month";
    private static final String KEYBOARD_DATE = "date";
    private static final String KEYBOARD_YEAR = "year";
    private static int sMonthKeyboardPosition = -1;
    private static int sDateKeyboardPosition = -1;
    private static int sYearKeyboardPosition = -1;
    private Button mSetButton;
    private boolean mYearOptional = false;
    protected View mDivider;
    private ColorStateList mTextColor;
    private int mKeyBackgroundResId;
    private int mButtonBackgroundResId;
    private int mTitleDividerColor;
    private int mKeyboardIndicatorColor;
    private int mCheckDrawableSrcResId;
    private int mDeleteDrawableSrcResId;
    private int mTheme = -1;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mDateFormatOrder = DateFormat.getDateFormatOrder((Context)this.mContext);
        this.mMonthAbbreviations = DatePicker.makeLocalizedMonthAbbreviations();
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        layoutInflater.inflate(this.getLayoutId(), (ViewGroup)this);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mKeyBackgroundResId = R.drawable.key_background_dark;
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mTitleDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mKeyboardIndicatorColor = this.getResources().getColor(R.color.default_keyboard_indicator_color_dark);
        this.mDeleteDrawableSrcResId = R.drawable.ic_backspace_dark;
        this.mCheckDrawableSrcResId = R.drawable.ic_check_dark;
    }

    protected int getLayoutId() {
        return R.layout.date_picker_view;
    }

    public void setTheme(int themeResId) {
        this.mTheme = themeResId;
        if (this.mTheme != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mKeyBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpKeyBackground, this.mKeyBackgroundResId);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mCheckDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpCheckIcon, this.mCheckDrawableSrcResId);
            this.mTitleDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpTitleDividerColor, this.mTitleDividerColor);
            this.mKeyboardIndicatorColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpKeyboardIndicatorColor, this.mKeyboardIndicatorColor);
            this.mDeleteDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDeleteIcon, this.mDeleteDrawableSrcResId);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        for (Button month : this.mMonths) {
            if (month == null) continue;
            month.setTextColor(this.mTextColor);
            month.setBackgroundResource(this.mKeyBackgroundResId);
        }
        for (Button dateNumber : this.mDateNumbers) {
            if (dateNumber == null) continue;
            dateNumber.setTextColor(this.mTextColor);
            dateNumber.setBackgroundResource(this.mKeyBackgroundResId);
        }
        for (Button yearNumber : this.mYearNumbers) {
            if (yearNumber == null) continue;
            yearNumber.setTextColor(this.mTextColor);
            yearNumber.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mKeyboardIndicator != null) {
            this.mKeyboardIndicator.setSelectedColor(this.mKeyboardIndicatorColor);
        }
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mTitleDividerColor);
        }
        if (this.mDateLeft != null) {
            this.mDateLeft.setTextColor(this.mTextColor);
            this.mDateLeft.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDateRight != null) {
            this.mDateRight.setBackgroundResource(this.mKeyBackgroundResId);
            this.mDateRight.setImageDrawable(this.getResources().getDrawable(this.mCheckDrawableSrcResId));
        }
        if (this.mDelete != null) {
            this.mDelete.setBackgroundResource(this.mButtonBackgroundResId);
            this.mDelete.setImageDrawable(this.getResources().getDrawable(this.mDeleteDrawableSrcResId));
        }
        if (this.mYearLeft != null) {
            this.mYearLeft.setTextColor(this.mTextColor);
            this.mYearLeft.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mYearRight != null) {
            this.mYearRight.setTextColor(this.mTextColor);
            this.mYearRight.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mEnteredDate != null) {
            this.mEnteredDate.setTheme(this.mTheme);
        }
    }

    protected void onFinishInflate() {
        int i;
        super.onFinishInflate();
        this.mDivider = this.findViewById(R.id.divider);
        for (i = 0; i < this.mDateInput.length; ++i) {
            this.mDateInput[i] = 0;
        }
        for (i = 0; i < this.mYearInput.length; ++i) {
            this.mYearInput[i] = 0;
        }
        this.mKeyboardIndicator = (UnderlinePageIndicatorPicker)this.findViewById(R.id.keyboard_indicator);
        this.mKeyboardPager = (ViewPager)this.findViewById(R.id.keyboard_pager);
        this.mKeyboardPager.setOffscreenPageLimit(2);
        this.mKeyboardPagerAdapter = new KeyboardPagerAdapter((LayoutInflater)this.mContext.getSystemService("layout_inflater"));
        this.mKeyboardPager.setAdapter((PagerAdapter)this.mKeyboardPagerAdapter);
        this.mKeyboardIndicator.setViewPager(this.mKeyboardPager);
        this.mKeyboardPager.setCurrentItem(0);
        this.mEnteredDate = (DateView)this.findViewById(R.id.date_text);
        this.mEnteredDate.setTheme(this.mTheme);
        this.mEnteredDate.setUnderlinePage(this.mKeyboardIndicator);
        this.mEnteredDate.setOnClick(this);
        this.mDelete = (ImageButton)this.findViewById(R.id.delete);
        this.mDelete.setOnClickListener((View.OnClickListener)this);
        this.mDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.setLeftRightEnabled();
        this.updateDate();
        this.updateKeypad();
    }

    public void updateDeleteButton() {
        boolean enabled;
        boolean bl = enabled = this.mMonthInput != -1 || this.mDateInputPointer != -1 || this.mYearInputPointer != -1;
        if (this.mDelete != null) {
            this.mDelete.setEnabled(enabled);
        }
    }

    public void onClick(View v) {
        v.performHapticFeedback(1);
        this.doOnClick(v);
        this.updateDeleteButton();
    }

    protected void doOnClick(View v) {
        if (v == this.mDelete) {
            switch (this.mDateFormatOrder[this.mKeyboardPager.getCurrentItem()]) {
                case 'M': {
                    if (this.mMonthInput == -1) break;
                    this.mMonthInput = -1;
                    break;
                }
                case 'd': {
                    if (this.mDateInputPointer >= 0) {
                        for (int i = 0; i < this.mDateInputPointer; ++i) {
                            this.mDateInput[i] = this.mDateInput[i + 1];
                        }
                        this.mDateInput[this.mDateInputPointer] = 0;
                        --this.mDateInputPointer;
                        break;
                    }
                    if (this.mKeyboardPager.getCurrentItem() <= 0) break;
                    this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() - 1, true);
                    break;
                }
                case 'y': {
                    if (this.mYearInputPointer >= 0) {
                        for (int i = 0; i < this.mYearInputPointer; ++i) {
                            this.mYearInput[i] = this.mYearInput[i + 1];
                        }
                        this.mYearInput[this.mYearInputPointer] = 0;
                        --this.mYearInputPointer;
                        break;
                    }
                    if (this.mKeyboardPager.getCurrentItem() <= 0) break;
                    this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() - 1, true);
                }
            }
        } else if (v == this.mDateRight) {
            this.onDateRightClicked();
        } else if (v == this.mEnteredDate.getDate()) {
            this.mKeyboardPager.setCurrentItem(sDateKeyboardPosition);
        } else if (v == this.mEnteredDate.getMonth()) {
            this.mKeyboardPager.setCurrentItem(sMonthKeyboardPosition);
        } else if (v == this.mEnteredDate.getYear()) {
            this.mKeyboardPager.setCurrentItem(sYearKeyboardPosition);
        } else if (v.getTag(R.id.date_keyboard).equals(KEYBOARD_MONTH)) {
            this.mMonthInput = (Integer)v.getTag(R.id.date_month_int);
            if (this.mKeyboardPager.getCurrentItem() < 2) {
                this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
            }
        } else if (v.getTag(R.id.date_keyboard).equals(KEYBOARD_DATE)) {
            this.addClickedDateNumber((Integer)v.getTag(R.id.numbers_key));
        } else if (v.getTag(R.id.date_keyboard).equals(KEYBOARD_YEAR)) {
            this.addClickedYearNumber((Integer)v.getTag(R.id.numbers_key));
        }
        this.updateKeypad();
    }

    public boolean onLongClick(View v) {
        v.performHapticFeedback(0);
        if (v == this.mDelete) {
            this.mDelete.setPressed(false);
            this.reset();
            this.updateKeypad();
            return true;
        }
        return false;
    }

    private void updateKeypad() {
        this.updateLeftRightButtons();
        this.updateDate();
        this.enableSetButton();
        this.updateDeleteButton();
        this.updateMonthKeys();
        this.updateDateKeys();
        this.updateYearKeys();
    }

    public void reset() {
        int i;
        for (i = 0; i < this.mDateInputSize; ++i) {
            this.mDateInput[i] = 0;
        }
        for (i = 0; i < this.mYearInputSize; ++i) {
            this.mYearInput[i] = 0;
        }
        this.mDateInputPointer = -1;
        this.mYearInputPointer = -1;
        this.mMonthInput = -1;
        this.mKeyboardPager.setCurrentItem(0, true);
        this.updateDate();
    }

    protected void updateDate() {
        String month = this.mMonthInput < 0 ? "" : this.mMonthAbbreviations[this.mMonthInput];
        this.mEnteredDate.setDate(month, this.getDayOfMonth(), this.getYear());
    }

    protected void setLeftRightEnabled() {
        if (this.mDateLeft != null) {
            this.mDateLeft.setEnabled(false);
        }
        if (this.mDateRight != null) {
            this.mDateRight.setEnabled(this.canGoToYear());
        }
        if (this.mYearLeft != null) {
            this.mYearLeft.setEnabled(false);
        }
        if (this.mYearRight != null) {
            this.mYearRight.setEnabled(false);
        }
    }

    private void addClickedDateNumber(int val) {
        if (this.mDateInputPointer < this.mDateInputSize - 1) {
            for (int i = this.mDateInputPointer; i >= 0; --i) {
                this.mDateInput[i + 1] = this.mDateInput[i];
            }
            ++this.mDateInputPointer;
            this.mDateInput[0] = val;
        }
        if ((this.getDayOfMonth() >= 4 || this.getMonthOfYear() == 1 && this.getDayOfMonth() >= 3) && this.mKeyboardPager.getCurrentItem() < 2) {
            this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
        }
    }

    private void addClickedYearNumber(int val) {
        if (this.mYearInputPointer < this.mYearInputSize - 1) {
            for (int i = this.mYearInputPointer; i >= 0; --i) {
                this.mYearInput[i + 1] = this.mYearInput[i];
            }
            ++this.mYearInputPointer;
            this.mYearInput[0] = val;
        }
        if (this.getYear() >= 1000 && this.mKeyboardPager.getCurrentItem() < 2) {
            this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
        }
    }

    private void onDateRightClicked() {
        if (this.mKeyboardPager.getCurrentItem() < 2) {
            this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
        }
    }

    private void updateMonthKeys() {
        int date = this.getDayOfMonth();
        for (int i = 0; i < this.mMonths.length; ++i) {
            if (this.mMonths[i] == null) continue;
            this.mMonths[i].setEnabled(true);
        }
        if (date > 29 && this.mMonths[1] != null) {
            this.mMonths[1].setEnabled(false);
        }
        if (date > 30) {
            if (this.mMonths[3] != null) {
                this.mMonths[3].setEnabled(false);
            }
            if (this.mMonths[5] != null) {
                this.mMonths[5].setEnabled(false);
            }
            if (this.mMonths[8] != null) {
                this.mMonths[8].setEnabled(false);
            }
            if (this.mMonths[10] != null) {
                this.mMonths[10].setEnabled(false);
            }
        }
    }

    private void updateDateKeys() {
        int date = this.getDayOfMonth();
        if (date >= 4) {
            this.setDateKeyRange(-1);
        } else if (date >= 3) {
            if (this.mMonthInput == 1) {
                this.setDateKeyRange(-1);
            } else if (this.mMonthInput == 3 || this.mMonthInput == 5 || this.mMonthInput == 8 || this.mMonthInput == 10) {
                this.setDateKeyRange(0);
            } else {
                this.setDateKeyRange(1);
            }
        } else if (date >= 2) {
            this.setDateKeyRange(9);
        } else if (date >= 1) {
            this.setDateKeyRange(9);
        } else {
            this.setDateMinKeyRange(1);
        }
    }

    private void updateYearKeys() {
        int year = this.getYear();
        if (year >= 1000) {
            this.setYearKeyRange(-1);
        } else if (year >= 1) {
            this.setYearKeyRange(9);
        } else {
            this.setYearMinKeyRange(1);
        }
    }

    private void setDateKeyRange(int maxKey) {
        for (int i = 0; i < this.mDateNumbers.length; ++i) {
            if (this.mDateNumbers[i] == null) continue;
            this.mDateNumbers[i].setEnabled(i <= maxKey);
        }
    }

    private void setDateMinKeyRange(int minKey) {
        for (int i = 0; i < this.mDateNumbers.length; ++i) {
            if (this.mDateNumbers[i] == null) continue;
            this.mDateNumbers[i].setEnabled(i >= minKey);
        }
    }

    private void setYearKeyRange(int maxKey) {
        for (int i = 0; i < this.mYearNumbers.length; ++i) {
            if (this.mYearNumbers[i] == null) continue;
            this.mYearNumbers[i].setEnabled(i <= maxKey);
        }
    }

    private void setYearMinKeyRange(int minKey) {
        for (int i = 0; i < this.mYearNumbers.length; ++i) {
            if (this.mYearNumbers[i] == null) continue;
            this.mYearNumbers[i].setEnabled(i >= minKey);
        }
    }

    private boolean canGoToYear() {
        return this.getDayOfMonth() > 0;
    }

    private void updateLeftRightButtons() {
        if (this.mDateRight != null) {
            this.mDateRight.setEnabled(this.canGoToYear());
        }
    }

    private void enableSetButton() {
        if (this.mSetButton == null) {
            return;
        }
        this.mSetButton.setEnabled(this.getDayOfMonth() > 0 && (this.mYearOptional || this.getYear() > 0) && this.getMonthOfYear() >= 0);
    }

    public void setSetButton(Button b) {
        this.mSetButton = b;
        this.enableSetButton();
    }

    public int getYear() {
        return this.mYearInput[3] * 1000 + this.mYearInput[2] * 100 + this.mYearInput[1] * 10 + this.mYearInput[0];
    }

    public int getMonthOfYear() {
        return this.mMonthInput;
    }

    public int getDayOfMonth() {
        return this.mDateInput[1] * 10 + this.mDateInput[0];
    }

    public void setDate(int year, int monthOfYear, int dayOfMonth) {
        this.mMonthInput = monthOfYear;
        this.mYearInput[3] = year / 1000;
        this.mYearInput[2] = year % 1000 / 100;
        this.mYearInput[1] = year % 100 / 10;
        this.mYearInput[0] = year % 10;
        if (year >= 1000) {
            this.mYearInputPointer = 3;
        } else if (year >= 100) {
            this.mYearInputPointer = 2;
        } else if (year >= 10) {
            this.mYearInputPointer = 1;
        } else if (year > 0) {
            this.mYearInputPointer = 0;
        }
        this.mDateInput[1] = dayOfMonth / 10;
        this.mDateInput[0] = dayOfMonth % 10;
        if (dayOfMonth >= 10) {
            this.mDateInputPointer = 1;
        } else if (dayOfMonth > 0) {
            this.mDateInputPointer = 0;
        }
        for (int i = 0; i < this.mDateFormatOrder.length; ++i) {
            char c = this.mDateFormatOrder[i];
            if (c == 'M' && monthOfYear == -1) {
                this.mKeyboardPager.setCurrentItem(i, true);
                break;
            }
            if (c == 'd' && dayOfMonth <= 0) {
                this.mKeyboardPager.setCurrentItem(i, true);
                break;
            }
            if (c != 'y' || year > 0) continue;
            this.mKeyboardPager.setCurrentItem(i, true);
            break;
        }
        this.updateKeypad();
    }

    public void setYearOptional(boolean yearOptional) {
        this.mYearOptional = yearOptional;
    }

    public static String[] makeLocalizedMonthAbbreviations() {
        return DatePicker.makeLocalizedMonthAbbreviations(Locale.getDefault());
    }

    public static String[] makeLocalizedMonthAbbreviations(Locale locale) {
        boolean hasLocale = locale != null;
        SimpleDateFormat monthAbbreviationFormat = hasLocale ? new SimpleDateFormat("MMM", locale) : new SimpleDateFormat("MMM");
        GregorianCalendar date = hasLocale ? new GregorianCalendar(locale) : new GregorianCalendar();
        date.set(1, 0);
        date.set(5, 1);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        String[] months = new String[12];
        for (int i = 0; i < months.length; ++i) {
            date.set(2, i);
            months[i] = monthAbbreviationFormat.format(date.getTime()).toUpperCase();
        }
        return months;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcel = super.onSaveInstanceState();
        SavedState state = new SavedState(parcel);
        state.mMonthInput = this.mMonthInput;
        state.mDateInput = this.mDateInput;
        state.mDateInputPointer = this.mDateInputPointer;
        state.mYearInput = this.mYearInput;
        state.mYearInputPointer = this.mYearInputPointer;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mDateInputPointer = savedState.mDateInputPointer;
        this.mYearInputPointer = savedState.mYearInputPointer;
        this.mDateInput = savedState.mDateInput;
        this.mYearInput = savedState.mYearInput;
        if (this.mDateInput == null) {
            this.mDateInput = new int[this.mDateInputSize];
            this.mDateInputPointer = -1;
        }
        if (this.mYearInput == null) {
            this.mYearInput = new int[this.mYearInputSize];
            this.mYearInputPointer = -1;
        }
        this.mMonthInput = savedState.mMonthInput;
        this.updateKeypad();
    }

    private static class SavedState
    extends View.BaseSavedState {
        int mDateInputPointer;
        int mYearInputPointer;
        int[] mDateInput;
        int[] mYearInput;
        int mMonthInput;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mDateInputPointer = in.readInt();
            this.mYearInputPointer = in.readInt();
            in.readIntArray(this.mDateInput);
            in.readIntArray(this.mYearInput);
            this.mMonthInput = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mDateInputPointer);
            dest.writeInt(this.mYearInputPointer);
            dest.writeIntArray(this.mDateInput);
            dest.writeIntArray(this.mYearInput);
            dest.writeInt(this.mMonthInput);
        }
    }

    private class KeyboardPagerAdapter
    extends PagerAdapter {
        private LayoutInflater mInflater;

        public KeyboardPagerAdapter(LayoutInflater inflater) {
            this.mInflater = inflater;
        }

        public Object instantiateItem(ViewGroup collection, int position) {
            View view;
            Resources res = DatePicker.this.mContext.getResources();
            if (DatePicker.this.mDateFormatOrder[position] == 'M') {
                sMonthKeyboardPosition = position;
                view = this.mInflater.inflate(R.layout.keyboard_text_with_header, collection, false);
                View v1 = view.findViewById(R.id.first);
                View v2 = view.findViewById(R.id.second);
                View v3 = view.findViewById(R.id.third);
                View v4 = view.findViewById(R.id.fourth);
                TextView header = (TextView)view.findViewById(R.id.header);
                header.setText(R.string.month_c);
                DatePicker.this.mMonths[0] = (Button)v1.findViewById(R.id.key_left);
                DatePicker.this.mMonths[1] = (Button)v1.findViewById(R.id.key_middle);
                DatePicker.this.mMonths[2] = (Button)v1.findViewById(R.id.key_right);
                DatePicker.this.mMonths[3] = (Button)v2.findViewById(R.id.key_left);
                DatePicker.this.mMonths[4] = (Button)v2.findViewById(R.id.key_middle);
                DatePicker.this.mMonths[5] = (Button)v2.findViewById(R.id.key_right);
                DatePicker.this.mMonths[6] = (Button)v3.findViewById(R.id.key_left);
                DatePicker.this.mMonths[7] = (Button)v3.findViewById(R.id.key_middle);
                DatePicker.this.mMonths[8] = (Button)v3.findViewById(R.id.key_right);
                DatePicker.this.mMonths[9] = (Button)v4.findViewById(R.id.key_left);
                DatePicker.this.mMonths[10] = (Button)v4.findViewById(R.id.key_middle);
                DatePicker.this.mMonths[11] = (Button)v4.findViewById(R.id.key_right);
                for (int i = 0; i < 12; ++i) {
                    DatePicker.this.mMonths[i].setOnClickListener((View.OnClickListener)DatePicker.this);
                    DatePicker.this.mMonths[i].setText((CharSequence)DatePicker.this.mMonthAbbreviations[i]);
                    DatePicker.this.mMonths[i].setTextColor(DatePicker.this.mTextColor);
                    DatePicker.this.mMonths[i].setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                    DatePicker.this.mMonths[i].setTag(R.id.date_keyboard, (Object)DatePicker.KEYBOARD_MONTH);
                    DatePicker.this.mMonths[i].setTag(R.id.date_month_int, (Object)i);
                }
            } else if (DatePicker.this.mDateFormatOrder[position] == 'd') {
                sDateKeyboardPosition = position;
                view = this.mInflater.inflate(R.layout.keyboard_right_drawable_with_header, collection, false);
                View v1 = view.findViewById(R.id.first);
                View v2 = view.findViewById(R.id.second);
                View v3 = view.findViewById(R.id.third);
                View v4 = view.findViewById(R.id.fourth);
                TextView header = (TextView)view.findViewById(R.id.header);
                header.setText(R.string.day_c);
                DatePicker.this.mDateNumbers[1] = (Button)v1.findViewById(R.id.key_left);
                DatePicker.this.mDateNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
                DatePicker.this.mDateNumbers[3] = (Button)v1.findViewById(R.id.key_right);
                DatePicker.this.mDateNumbers[4] = (Button)v2.findViewById(R.id.key_left);
                DatePicker.this.mDateNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
                DatePicker.this.mDateNumbers[6] = (Button)v2.findViewById(R.id.key_right);
                DatePicker.this.mDateNumbers[7] = (Button)v3.findViewById(R.id.key_left);
                DatePicker.this.mDateNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
                DatePicker.this.mDateNumbers[9] = (Button)v3.findViewById(R.id.key_right);
                DatePicker.this.mDateLeft = (Button)v4.findViewById(R.id.key_left);
                DatePicker.this.mDateLeft.setTextColor(DatePicker.this.mTextColor);
                DatePicker.this.mDateLeft.setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                DatePicker.this.mDateNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
                DatePicker.this.mDateRight = (ImageButton)v4.findViewById(R.id.key_right);
                for (int i = 0; i < 10; ++i) {
                    DatePicker.this.mDateNumbers[i].setOnClickListener((View.OnClickListener)DatePicker.this);
                    DatePicker.this.mDateNumbers[i].setText((CharSequence)String.format(Locale.getDefault(), "%d", i));
                    DatePicker.this.mDateNumbers[i].setTextColor(DatePicker.this.mTextColor);
                    DatePicker.this.mDateNumbers[i].setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                    DatePicker.this.mDateNumbers[i].setTag(R.id.date_keyboard, (Object)DatePicker.KEYBOARD_DATE);
                    DatePicker.this.mDateNumbers[i].setTag(R.id.numbers_key, (Object)i);
                }
                DatePicker.this.mDateRight.setImageDrawable(res.getDrawable(DatePicker.this.mCheckDrawableSrcResId));
                DatePicker.this.mDateRight.setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                DatePicker.this.mDateRight.setOnClickListener((View.OnClickListener)DatePicker.this);
            } else if (DatePicker.this.mDateFormatOrder[position] == 'y') {
                sYearKeyboardPosition = position;
                view = this.mInflater.inflate(R.layout.keyboard_with_header, collection, false);
                View v1 = view.findViewById(R.id.first);
                View v2 = view.findViewById(R.id.second);
                View v3 = view.findViewById(R.id.third);
                View v4 = view.findViewById(R.id.fourth);
                TextView header = (TextView)view.findViewById(R.id.header);
                header.setText(R.string.year_c);
                DatePicker.this.mYearNumbers[1] = (Button)v1.findViewById(R.id.key_left);
                DatePicker.this.mYearNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
                DatePicker.this.mYearNumbers[3] = (Button)v1.findViewById(R.id.key_right);
                DatePicker.this.mYearNumbers[4] = (Button)v2.findViewById(R.id.key_left);
                DatePicker.this.mYearNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
                DatePicker.this.mYearNumbers[6] = (Button)v2.findViewById(R.id.key_right);
                DatePicker.this.mYearNumbers[7] = (Button)v3.findViewById(R.id.key_left);
                DatePicker.this.mYearNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
                DatePicker.this.mYearNumbers[9] = (Button)v3.findViewById(R.id.key_right);
                DatePicker.this.mYearLeft = (Button)v4.findViewById(R.id.key_left);
                DatePicker.this.mYearLeft.setTextColor(DatePicker.this.mTextColor);
                DatePicker.this.mYearLeft.setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                DatePicker.this.mYearNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
                DatePicker.this.mYearRight = (Button)v4.findViewById(R.id.key_right);
                DatePicker.this.mYearRight.setTextColor(DatePicker.this.mTextColor);
                DatePicker.this.mYearRight.setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                for (int i = 0; i < 10; ++i) {
                    DatePicker.this.mYearNumbers[i].setOnClickListener((View.OnClickListener)DatePicker.this);
                    DatePicker.this.mYearNumbers[i].setText((CharSequence)String.format(Locale.getDefault(), "%d", i));
                    DatePicker.this.mYearNumbers[i].setTextColor(DatePicker.this.mTextColor);
                    DatePicker.this.mYearNumbers[i].setBackgroundResource(DatePicker.this.mKeyBackgroundResId);
                    DatePicker.this.mYearNumbers[i].setTag(R.id.date_keyboard, (Object)DatePicker.KEYBOARD_YEAR);
                    DatePicker.this.mYearNumbers[i].setTag(R.id.numbers_key, (Object)i);
                }
            } else {
                view = new View(DatePicker.this.mContext);
            }
            DatePicker.this.setLeftRightEnabled();
            DatePicker.this.updateDate();
            DatePicker.this.updateKeypad();
            collection.addView(view, 0);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public int getCount() {
            return 3;
        }

        public boolean isViewFromObject(View view, Object o) {
            return view == o;
        }
    }
}

