/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.expirationpicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.datepicker.DatePicker;
import com.codetroopers.betterpickers.expirationpicker.ExpirationView;
import com.codetroopers.betterpickers.widget.UnderlinePageIndicatorPicker;
import java.util.Calendar;

public class ExpirationPicker
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    private static final int EXPIRATION_MONTH_POSITION = 0;
    private static final int EXPIRATION_YEAR_POSITION = 1;
    protected int mYearInputSize = 4;
    protected int mMonthInput = -1;
    protected int[] mYearInput = new int[this.mYearInputSize];
    protected int mYearInputPointer = -1;
    protected int mMinimumYear;
    protected final Button[] mMonths = new Button[12];
    protected final Button[] mYearNumbers = new Button[10];
    protected Button mYearLeft;
    protected Button mYearRight;
    protected UnderlinePageIndicatorPicker mKeyboardIndicator;
    protected ViewPager mKeyboardPager;
    protected KeyboardPagerAdapter mKeyboardPagerAdapter;
    protected ImageButton mDelete;
    protected ExpirationView mEnteredExpiration;
    protected String[] mMonthAbbreviations;
    protected final Context mContext;
    private char[] mDateFormatOrder;
    private static final String KEYBOARD_MONTH = "month";
    private static final String KEYBOARD_YEAR = "year";
    private static int sMonthKeyboardPosition = -1;
    private static int sYearKeyboardPosition = -1;
    private Button mSetButton;
    protected View mDivider;
    private ColorStateList mTextColor;
    private int mKeyBackgroundResId;
    private int mButtonBackgroundResId;
    private int mTitleDividerColor;
    private int mKeyboardIndicatorColor;
    private int mCheckDrawableSrcResId;
    private int mDeleteDrawableSrcResId;
    private int mTheme = -1;

    public ExpirationPicker(Context context) {
        this(context, null);
    }

    public ExpirationPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mDateFormatOrder = DateFormat.getDateFormatOrder((Context)this.mContext);
        this.mMonthAbbreviations = DatePicker.makeLocalizedMonthAbbreviations();
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        layoutInflater.inflate(this.getLayoutId(), (ViewGroup)this);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mKeyBackgroundResId = R.drawable.key_background_dark;
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mTitleDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mKeyboardIndicatorColor = this.getResources().getColor(R.color.default_keyboard_indicator_color_dark);
        this.mDeleteDrawableSrcResId = R.drawable.ic_backspace_dark;
        this.mCheckDrawableSrcResId = R.drawable.ic_check_dark;
        this.mMinimumYear = Calendar.getInstance().get(1);
    }

    protected int getLayoutId() {
        return R.layout.expiration_picker_view;
    }

    public void setTheme(int themeResId) {
        this.mTheme = themeResId;
        if (this.mTheme != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mKeyBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpKeyBackground, this.mKeyBackgroundResId);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mCheckDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpCheckIcon, this.mCheckDrawableSrcResId);
            this.mTitleDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpTitleDividerColor, this.mTitleDividerColor);
            this.mKeyboardIndicatorColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpKeyboardIndicatorColor, this.mKeyboardIndicatorColor);
            this.mDeleteDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDeleteIcon, this.mDeleteDrawableSrcResId);
        }
        this.restyleViews();
    }

    public void setMinYear(int year) {
        this.mMinimumYear = year;
    }

    private void restyleViews() {
        for (Button month : this.mMonths) {
            if (month == null) continue;
            month.setTextColor(this.mTextColor);
            month.setBackgroundResource(this.mKeyBackgroundResId);
        }
        for (Button yearNumber : this.mYearNumbers) {
            if (yearNumber == null) continue;
            yearNumber.setTextColor(this.mTextColor);
            yearNumber.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mKeyboardIndicator != null) {
            this.mKeyboardIndicator.setSelectedColor(this.mKeyboardIndicatorColor);
        }
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mTitleDividerColor);
        }
        if (this.mDelete != null) {
            this.mDelete.setBackgroundResource(this.mButtonBackgroundResId);
            this.mDelete.setImageDrawable(this.getResources().getDrawable(this.mDeleteDrawableSrcResId));
        }
        if (this.mYearLeft != null) {
            this.mYearLeft.setTextColor(this.mTextColor);
            this.mYearLeft.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mYearRight != null) {
            this.mYearRight.setTextColor(this.mTextColor);
            this.mYearRight.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mEnteredExpiration != null) {
            this.mEnteredExpiration.setTheme(this.mTheme);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDivider = this.findViewById(R.id.divider);
        for (int i = 0; i < this.mYearInput.length; ++i) {
            this.mYearInput[i] = 0;
        }
        this.mKeyboardIndicator = (UnderlinePageIndicatorPicker)this.findViewById(R.id.keyboard_indicator);
        this.mKeyboardPager = (ViewPager)this.findViewById(R.id.keyboard_pager);
        this.mKeyboardPager.setOffscreenPageLimit(2);
        this.mKeyboardPagerAdapter = new KeyboardPagerAdapter((LayoutInflater)this.mContext.getSystemService("layout_inflater"));
        this.mKeyboardPager.setAdapter((PagerAdapter)this.mKeyboardPagerAdapter);
        this.mKeyboardIndicator.setViewPager(this.mKeyboardPager);
        this.mKeyboardPager.setCurrentItem(0);
        this.mEnteredExpiration = (ExpirationView)this.findViewById(R.id.date_text);
        this.mEnteredExpiration.setTheme(this.mTheme);
        this.mEnteredExpiration.setUnderlinePage(this.mKeyboardIndicator);
        this.mEnteredExpiration.setOnClick(this);
        this.mDelete = (ImageButton)this.findViewById(R.id.delete);
        this.mDelete.setOnClickListener((View.OnClickListener)this);
        this.mDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.addClickedYearNumber(this.mMinimumYear / 1000);
        this.addClickedYearNumber(this.mMinimumYear % 1000 / 100);
        this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() - 1, true);
        this.setLeftRightEnabled();
        this.updateExpiration();
        this.updateKeypad();
    }

    public void updateDeleteButton() {
        boolean enabled;
        boolean bl = enabled = this.mMonthInput != -1 || this.mYearInputPointer != -1;
        if (this.mDelete != null) {
            this.mDelete.setEnabled(enabled);
        }
    }

    public void onClick(View v) {
        v.performHapticFeedback(1);
        this.doOnClick(v);
        this.updateDeleteButton();
    }

    protected void doOnClick(View v) {
        if (v == this.mDelete) {
            switch (this.mKeyboardPager.getCurrentItem()) {
                case 0: {
                    if (this.mMonthInput == -1) break;
                    this.mMonthInput = -1;
                    break;
                }
                case 1: {
                    if (this.mYearInputPointer >= 2) {
                        for (int i = 0; i < this.mYearInputPointer; ++i) {
                            this.mYearInput[i] = this.mYearInput[i + 1];
                        }
                        this.mYearInput[this.mYearInputPointer] = 0;
                        --this.mYearInputPointer;
                        break;
                    }
                    if (this.mKeyboardPager.getCurrentItem() <= 0) break;
                    this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() - 1, true);
                }
            }
        } else if (v == this.mEnteredExpiration.getMonth()) {
            this.mKeyboardPager.setCurrentItem(sMonthKeyboardPosition);
        } else if (v == this.mEnteredExpiration.getYear()) {
            this.mKeyboardPager.setCurrentItem(sYearKeyboardPosition);
        } else if (v.getTag(R.id.date_keyboard).equals(KEYBOARD_MONTH)) {
            this.mMonthInput = (Integer)v.getTag(R.id.date_month_int);
            if (this.mKeyboardPager.getCurrentItem() < 2) {
                this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
            }
        } else if (v.getTag(R.id.date_keyboard).equals(KEYBOARD_YEAR)) {
            this.addClickedYearNumber((Integer)v.getTag(R.id.numbers_key));
        }
        this.updateKeypad();
    }

    public boolean onLongClick(View v) {
        v.performHapticFeedback(0);
        if (v == this.mDelete) {
            this.mDelete.setPressed(false);
            this.reset();
            this.updateKeypad();
            return true;
        }
        return false;
    }

    private void updateKeypad() {
        this.updateExpiration();
        this.enableSetButton();
        this.updateDeleteButton();
        this.updateMonthKeys();
        this.updateYearKeys();
    }

    public void reset() {
        for (int i = 0; i < this.mYearInputSize; ++i) {
            this.mYearInput[i] = 0;
        }
        this.mYearInputPointer = -1;
        this.mMonthInput = -1;
        this.mKeyboardPager.setCurrentItem(0, true);
        this.updateExpiration();
    }

    @SuppressLint(value={"DefaultLocale"})
    protected void updateExpiration() {
        String month = this.mMonthInput < 0 ? "" : String.format("%02d", this.mMonthInput);
        this.mEnteredExpiration.setExpiration(month, this.getYear());
    }

    protected void setLeftRightEnabled() {
        if (this.mYearLeft != null) {
            this.mYearLeft.setEnabled(false);
        }
        if (this.mYearRight != null) {
            this.mYearRight.setEnabled(false);
        }
    }

    private void addClickedYearNumber(int val) {
        if (this.mYearInputPointer < this.mYearInputSize - 1) {
            for (int i = this.mYearInputPointer; i >= 0; --i) {
                this.mYearInput[i + 1] = this.mYearInput[i];
            }
            ++this.mYearInputPointer;
            this.mYearInput[0] = val;
        }
        if (this.mKeyboardPager.getCurrentItem() < 2) {
            this.mKeyboardPager.setCurrentItem(this.mKeyboardPager.getCurrentItem() + 1, true);
        }
    }

    private void updateMonthKeys() {
        for (int i = 0; i < this.mMonths.length; ++i) {
            if (this.mMonths[i] == null) continue;
            this.mMonths[i].setEnabled(true);
        }
    }

    private void updateYearKeys() {
        if (this.mYearInputPointer == 1) {
            this.setYearMinKeyRange(this.mMinimumYear % 100 / 10);
        } else if (this.mYearInputPointer == 2) {
            this.setYearMinKeyRange(Math.max(0, this.mMinimumYear % 100 - this.mYearInput[0] * 10));
        } else if (this.mYearInputPointer == 3) {
            this.setYearKeyRange(-1);
        }
    }

    private void setYearKeyRange(int maxKey) {
        for (int i = 0; i < this.mYearNumbers.length; ++i) {
            if (this.mYearNumbers[i] == null) continue;
            this.mYearNumbers[i].setEnabled(i <= maxKey);
        }
    }

    private void setYearMinKeyRange(int minKey) {
        for (int i = 0; i < this.mYearNumbers.length; ++i) {
            if (this.mYearNumbers[i] == null) continue;
            this.mYearNumbers[i].setEnabled(i >= minKey);
        }
    }

    private void enableSetButton() {
        if (this.mSetButton == null) {
            return;
        }
        this.mSetButton.setEnabled(this.getYear() >= this.mMinimumYear && this.getMonthOfYear() > 0);
    }

    public void setSetButton(Button b) {
        this.mSetButton = b;
        this.enableSetButton();
    }

    public int getYear() {
        return this.mYearInput[3] * 1000 + this.mYearInput[2] * 100 + this.mYearInput[1] * 10 + this.mYearInput[0];
    }

    public int getMonthOfYear() {
        return this.mMonthInput;
    }

    public void setExpiration(int year, int monthOfYear) {
        if (year != 0 && year < this.mMinimumYear) {
            throw new IllegalArgumentException("Years past the minimum set year are not allowed. Specify " + this.mMinimumYear + " or above.");
        }
        this.mMonthInput = monthOfYear;
        this.mYearInput[3] = year / 1000;
        this.mYearInput[2] = year % 1000 / 100;
        this.mYearInput[1] = year % 100 / 10;
        this.mYearInput[0] = year % 10;
        if (year >= 1000) {
            this.mYearInputPointer = 3;
        } else if (year >= 100) {
            this.mYearInputPointer = 2;
        } else if (year >= 10) {
            this.mYearInputPointer = 1;
        } else if (year > 0) {
            this.mYearInputPointer = 0;
        }
        for (int i = 0; i < this.mDateFormatOrder.length; ++i) {
            char c = this.mDateFormatOrder[i];
            if (c == 'M' && monthOfYear == -1) {
                this.mKeyboardPager.setCurrentItem(i, true);
                break;
            }
            if (c != 'y' || year > 0) continue;
            this.mKeyboardPager.setCurrentItem(i, true);
            break;
        }
        this.updateKeypad();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcel = super.onSaveInstanceState();
        SavedState state = new SavedState(parcel);
        state.mMonthInput = this.mMonthInput;
        state.mYearInput = this.mYearInput;
        state.mYearInputPointer = this.mYearInputPointer;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mYearInputPointer = savedState.mYearInputPointer;
        this.mYearInput = savedState.mYearInput;
        if (this.mYearInput == null) {
            this.mYearInput = new int[this.mYearInputSize];
            this.mYearInputPointer = -1;
        }
        this.mMonthInput = savedState.mMonthInput;
        this.updateKeypad();
    }

    private static class SavedState
    extends View.BaseSavedState {
        int mYearInputPointer;
        int[] mYearInput;
        int mMonthInput;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mYearInputPointer = in.readInt();
            in.readIntArray(this.mYearInput);
            this.mMonthInput = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYearInputPointer);
            dest.writeIntArray(this.mYearInput);
            dest.writeInt(this.mMonthInput);
        }
    }

    private class KeyboardPagerAdapter
    extends PagerAdapter {
        private LayoutInflater mInflater;

        public KeyboardPagerAdapter(LayoutInflater inflater) {
            this.mInflater = inflater;
        }

        public Object instantiateItem(ViewGroup collection, int position) {
            View view;
            Resources res = ExpirationPicker.this.mContext.getResources();
            if (position == 0) {
                sMonthKeyboardPosition = position;
                view = this.mInflater.inflate(R.layout.keyboard_text, collection, false);
                View v1 = view.findViewById(R.id.first);
                View v2 = view.findViewById(R.id.second);
                View v3 = view.findViewById(R.id.third);
                View v4 = view.findViewById(R.id.fourth);
                ExpirationPicker.this.mMonths[0] = (Button)v1.findViewById(R.id.key_left);
                ExpirationPicker.this.mMonths[1] = (Button)v1.findViewById(R.id.key_middle);
                ExpirationPicker.this.mMonths[2] = (Button)v1.findViewById(R.id.key_right);
                ExpirationPicker.this.mMonths[3] = (Button)v2.findViewById(R.id.key_left);
                ExpirationPicker.this.mMonths[4] = (Button)v2.findViewById(R.id.key_middle);
                ExpirationPicker.this.mMonths[5] = (Button)v2.findViewById(R.id.key_right);
                ExpirationPicker.this.mMonths[6] = (Button)v3.findViewById(R.id.key_left);
                ExpirationPicker.this.mMonths[7] = (Button)v3.findViewById(R.id.key_middle);
                ExpirationPicker.this.mMonths[8] = (Button)v3.findViewById(R.id.key_right);
                ExpirationPicker.this.mMonths[9] = (Button)v4.findViewById(R.id.key_left);
                ExpirationPicker.this.mMonths[10] = (Button)v4.findViewById(R.id.key_middle);
                ExpirationPicker.this.mMonths[11] = (Button)v4.findViewById(R.id.key_right);
                for (int i = 0; i < 12; ++i) {
                    ExpirationPicker.this.mMonths[i].setOnClickListener((View.OnClickListener)ExpirationPicker.this);
                    ExpirationPicker.this.mMonths[i].setText((CharSequence)String.format("%02d", i + 1));
                    ExpirationPicker.this.mMonths[i].setTextColor(ExpirationPicker.this.mTextColor);
                    ExpirationPicker.this.mMonths[i].setBackgroundResource(ExpirationPicker.this.mKeyBackgroundResId);
                    ExpirationPicker.this.mMonths[i].setTag(R.id.date_keyboard, (Object)ExpirationPicker.KEYBOARD_MONTH);
                    ExpirationPicker.this.mMonths[i].setTag(R.id.date_month_int, (Object)(i + 1));
                }
            } else if (position == 1) {
                sYearKeyboardPosition = position;
                view = this.mInflater.inflate(R.layout.keyboard, collection, false);
                View v1 = view.findViewById(R.id.first);
                View v2 = view.findViewById(R.id.second);
                View v3 = view.findViewById(R.id.third);
                View v4 = view.findViewById(R.id.fourth);
                ExpirationPicker.this.mYearNumbers[1] = (Button)v1.findViewById(R.id.key_left);
                ExpirationPicker.this.mYearNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
                ExpirationPicker.this.mYearNumbers[3] = (Button)v1.findViewById(R.id.key_right);
                ExpirationPicker.this.mYearNumbers[4] = (Button)v2.findViewById(R.id.key_left);
                ExpirationPicker.this.mYearNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
                ExpirationPicker.this.mYearNumbers[6] = (Button)v2.findViewById(R.id.key_right);
                ExpirationPicker.this.mYearNumbers[7] = (Button)v3.findViewById(R.id.key_left);
                ExpirationPicker.this.mYearNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
                ExpirationPicker.this.mYearNumbers[9] = (Button)v3.findViewById(R.id.key_right);
                ExpirationPicker.this.mYearLeft = (Button)v4.findViewById(R.id.key_left);
                ExpirationPicker.this.mYearLeft.setTextColor(ExpirationPicker.this.mTextColor);
                ExpirationPicker.this.mYearLeft.setBackgroundResource(ExpirationPicker.this.mKeyBackgroundResId);
                ExpirationPicker.this.mYearNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
                ExpirationPicker.this.mYearRight = (Button)v4.findViewById(R.id.key_right);
                ExpirationPicker.this.mYearRight.setTextColor(ExpirationPicker.this.mTextColor);
                ExpirationPicker.this.mYearRight.setBackgroundResource(ExpirationPicker.this.mKeyBackgroundResId);
                for (int i = 0; i < 10; ++i) {
                    ExpirationPicker.this.mYearNumbers[i].setOnClickListener((View.OnClickListener)ExpirationPicker.this);
                    ExpirationPicker.this.mYearNumbers[i].setText((CharSequence)String.format("%d", i));
                    ExpirationPicker.this.mYearNumbers[i].setTextColor(ExpirationPicker.this.mTextColor);
                    ExpirationPicker.this.mYearNumbers[i].setBackgroundResource(ExpirationPicker.this.mKeyBackgroundResId);
                    ExpirationPicker.this.mYearNumbers[i].setTag(R.id.date_keyboard, (Object)ExpirationPicker.KEYBOARD_YEAR);
                    ExpirationPicker.this.mYearNumbers[i].setTag(R.id.numbers_key, (Object)i);
                }
            } else {
                view = new View(ExpirationPicker.this.mContext);
            }
            ExpirationPicker.this.setLeftRightEnabled();
            ExpirationPicker.this.updateExpiration();
            ExpirationPicker.this.updateKeypad();
            collection.addView(view, 0);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public int getCount() {
            return 2;
        }

        public boolean isViewFromObject(View view, Object o) {
            return view == o;
        }
    }
}

