/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.numberpicker;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.codetroopers.betterpickers.OnDialogDismissListener;
import com.codetroopers.betterpickers.numberpicker.NumberPickerDialogFragment;
import java.math.BigDecimal;
import java.util.Vector;

public class NumberPickerBuilder {
    private FragmentManager manager;
    private Integer styleResId;
    private Fragment targetFragment;
    private BigDecimal minNumber;
    private BigDecimal maxNumber;
    private Integer plusMinusVisibility;
    private Integer decimalVisibility;
    private String labelText;
    private int mReference;
    private Vector<NumberPickerDialogFragment.NumberPickerDialogHandlerV2> mNumberPickerDialogHandlersV2 = new Vector();
    private Integer currentNumberValue;
    private Double currentDecimalValue;
    private Integer currentSignValue;
    private OnDialogDismissListener mOnDismissListener;

    public NumberPickerBuilder setFragmentManager(FragmentManager manager) {
        this.manager = manager;
        return this;
    }

    public NumberPickerBuilder setStyleResId(int styleResId) {
        this.styleResId = styleResId;
        return this;
    }

    public NumberPickerBuilder setTargetFragment(Fragment targetFragment) {
        this.targetFragment = targetFragment;
        return this;
    }

    public NumberPickerBuilder setReference(int reference) {
        this.mReference = reference;
        return this;
    }

    public NumberPickerBuilder setCurrentNumber(Integer number) {
        if (number != null) {
            if (number >= 0) {
                this.currentSignValue = 0;
            } else {
                this.currentSignValue = 1;
                number = number * -1;
            }
            this.currentNumberValue = number;
            this.currentDecimalValue = null;
        }
        return this;
    }

    public NumberPickerBuilder setCurrentNumber(BigDecimal number) {
        if (number != null) {
            if (number.signum() >= 0) {
                this.currentSignValue = 0;
            } else {
                this.currentSignValue = 1;
                number = number.abs();
            }
            BigDecimal[] numberInput = number.divideAndRemainder(BigDecimal.ONE);
            this.currentNumberValue = numberInput[0].intValue();
            this.currentDecimalValue = numberInput[1].doubleValue();
        }
        return this;
    }

    public NumberPickerBuilder setMinNumber(BigDecimal minNumber) {
        this.minNumber = minNumber;
        return this;
    }

    public NumberPickerBuilder setMaxNumber(BigDecimal maxNumber) {
        this.maxNumber = maxNumber;
        return this;
    }

    public NumberPickerBuilder setPlusMinusVisibility(int plusMinusVisibility) {
        this.plusMinusVisibility = plusMinusVisibility;
        return this;
    }

    public NumberPickerBuilder setDecimalVisibility(int decimalVisibility) {
        this.decimalVisibility = decimalVisibility;
        return this;
    }

    public NumberPickerBuilder setLabelText(String labelText) {
        this.labelText = labelText;
        return this;
    }

    public NumberPickerBuilder addNumberPickerDialogHandler(NumberPickerDialogFragment.NumberPickerDialogHandlerV2 handler) {
        this.mNumberPickerDialogHandlersV2.add(handler);
        return this;
    }

    public NumberPickerBuilder removeNumberPickerDialogHandler(NumberPickerDialogFragment.NumberPickerDialogHandlerV2 handler) {
        this.mNumberPickerDialogHandlersV2.remove(handler);
        return this;
    }

    public void show() {
        if (this.manager == null || this.styleResId == null) {
            Log.e((String)"NumberPickerBuilder", (String)"setFragmentManager() and setStyleResId() must be called.");
            return;
        }
        FragmentTransaction ft = this.manager.beginTransaction();
        Fragment prev = this.manager.findFragmentByTag("number_dialog");
        if (prev != null) {
            ft.remove(prev).commit();
            ft = this.manager.beginTransaction();
        }
        ft.addToBackStack(null);
        NumberPickerDialogFragment fragment = NumberPickerDialogFragment.newInstance(this.mReference, this.styleResId, this.minNumber, this.maxNumber, this.plusMinusVisibility, this.decimalVisibility, this.labelText, this.currentNumberValue, this.currentDecimalValue, this.currentSignValue);
        if (this.targetFragment != null) {
            fragment.setTargetFragment(this.targetFragment, 0);
        }
        fragment.setNumberPickerDialogHandlersV2(this.mNumberPickerDialogHandlersV2);
        fragment.setOnDismissListener(this.mOnDismissListener);
        fragment.show(ft, "number_dialog");
    }

    public NumberPickerBuilder setOnDismissListener(OnDialogDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }
}

