/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timepicker;

import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.OnDialogDismissListener;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timepicker.TimePicker;
import java.util.Vector;

public class TimePickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "TimePickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "TimePickerDialogFragment_ThemeResIdKey";
    private TimePicker mPicker;
    private int mReference = -1;
    private int mTheme = -1;
    private ColorStateList mTextColor;
    private int mDialogBackgroundResId;
    private Vector<TimePickerDialogHandler> mTimePickerDialogHandlers = new Vector();
    private OnDialogDismissListener mDismissCallback;

    public static TimePickerDialogFragment newInstance(int reference, int themeResId) {
        TimePickerDialogFragment frag = new TimePickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.time_picker_dialog, container, false);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TimePickerDialogFragment.this.dismiss();
            }
        });
        cancelButton.setTextColor(this.mTextColor);
        doneButton.setTextColor(this.mTextColor);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (TimePickerDialogHandler handler : TimePickerDialogFragment.this.mTimePickerDialogHandlers) {
                    handler.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                }
                FragmentActivity activity = TimePickerDialogFragment.this.getActivity();
                Fragment fragment = TimePickerDialogFragment.this.getTargetFragment();
                if (activity instanceof TimePickerDialogHandler) {
                    TimePickerDialogHandler act = (TimePickerDialogHandler)activity;
                    act.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                } else if (fragment instanceof TimePickerDialogHandler) {
                    TimePickerDialogHandler frag = (TimePickerDialogHandler)fragment;
                    frag.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                }
                TimePickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (TimePicker)view.findViewById(R.id.time_picker);
        this.mPicker.setSetButton(doneButton);
        this.mPicker.setTheme(this.mTheme);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return view;
    }

    public void onDismiss(DialogInterface dialoginterface) {
        super.onDismiss(dialoginterface);
        if (this.mDismissCallback != null) {
            this.mDismissCallback.onDialogDismiss(dialoginterface);
        }
    }

    public void setTimePickerDialogHandlers(Vector<TimePickerDialogHandler> handlers) {
        this.mTimePickerDialogHandlers = handlers;
    }

    public void setOnDismissListener(OnDialogDismissListener ondialogdismisslistener) {
        this.mDismissCallback = ondialogdismisslistener;
    }

    public static interface TimePickerDialogHandler {
        public void onDialogTimeSet(int var1, int var2, int var3);
    }
}

