/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneData;
import java.util.ArrayList;
import java.util.Collections;

public class TimeZoneFilterTypeAdapter
extends BaseAdapter
implements Filterable,
View.OnClickListener {
    public static final String TAG = "TimeZoneFilterTypeAdapter";
    private Typeface mSansSerifLightTypeface;
    private static final boolean DEBUG = false;
    public static final int FILTER_TYPE_EMPTY = -1;
    public static final int FILTER_TYPE_NONE = 0;
    public static final int FILTER_TYPE_COUNTRY = 1;
    public static final int FILTER_TYPE_STATE = 2;
    public static final int FILTER_TYPE_GMT = 3;
    private ArrayList<FilterTypeResult> mLiveResults = new ArrayList();
    private int mLiveResultsCount = 0;
    private ArrayFilter mFilter;
    private LayoutInflater mInflater;
    private TimeZoneData mTimeZoneData;
    private OnSetFilterListener mListener;
    View.OnClickListener mDummyListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    public TimeZoneFilterTypeAdapter(Context context, TimeZoneData tzd, OnSetFilterListener l) {
        this.mTimeZoneData = tzd;
        this.mListener = l;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mSansSerifLightTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Roboto-Light.ttf");
    }

    public int getCount() {
        return this.mLiveResultsCount;
    }

    public FilterTypeResult getItem(int position) {
        return this.mLiveResults.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View v;
        if (convertView != null) {
            v = convertView;
        } else {
            v = this.mInflater.inflate(R.layout.time_zone_filter_item, parent, false);
            ViewHolder.setupViewHolder(v);
        }
        ViewHolder vh = (ViewHolder)v.getTag();
        if (position >= this.mLiveResults.size()) {
            Log.e((String)TAG, (String)("getView: " + position + " of " + this.mLiveResults.size()));
        }
        FilterTypeResult filter = this.mLiveResults.get(position);
        vh.filterType = filter.type;
        vh.str = filter.constraint;
        vh.time = filter.time;
        vh.strTextView.setText((CharSequence)filter.constraint);
        vh.strTextView.setTypeface(this.mSansSerifLightTypeface);
        return v;
    }

    public void onClick(View v) {
        if (this.mListener != null && v != null) {
            ViewHolder vh = (ViewHolder)v.getTag();
            this.mListener.onSetFilter(vh.filterType, vh.str, vh.time);
        }
        this.notifyDataSetInvalidated();
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            int num;
            Filter.FilterResults results = new Filter.FilterResults();
            String prefixString = null;
            if (prefix != null) {
                prefixString = prefix.toString().trim().toLowerCase();
            }
            if (TextUtils.isEmpty(prefixString)) {
                results.values = null;
                results.count = 0;
                return results;
            }
            ArrayList<FilterTypeResult> filtered = new ArrayList<FilterTypeResult>();
            boolean gmtOnly = false;
            int startParsePosition = 0;
            if (prefixString.charAt(0) == '+' || prefixString.charAt(0) == '-') {
                gmtOnly = true;
            }
            if (prefixString.startsWith("gmt")) {
                startParsePosition = 3;
                gmtOnly = true;
            }
            if ((num = this.parseNum(prefixString, startParsePosition)) != Integer.MIN_VALUE) {
                boolean positiveOnly = prefixString.length() > startParsePosition && prefixString.charAt(startParsePosition) == '+';
                this.handleSearchByGmt(filtered, num, positiveOnly);
            }
            ArrayList<String> countries = new ArrayList<String>();
            for (String country : ((TimeZoneFilterTypeAdapter)TimeZoneFilterTypeAdapter.this).mTimeZoneData.mTimeZonesByCountry.keySet()) {
                if (TextUtils.isEmpty((CharSequence)country)) continue;
                String lowerCaseCountry = country.toLowerCase();
                boolean isMatch = false;
                if (lowerCaseCountry.startsWith(prefixString) || lowerCaseCountry.charAt(0) == prefixString.charAt(0) && this.isStartingInitialsFor(prefixString, lowerCaseCountry)) {
                    isMatch = true;
                } else if (lowerCaseCountry.contains(" ")) {
                    for (String word : lowerCaseCountry.split(" ")) {
                        if (!word.startsWith(prefixString)) continue;
                        isMatch = true;
                        break;
                    }
                }
                if (!isMatch) continue;
                countries.add(country);
            }
            if (countries.size() > 0) {
                Collections.sort(countries);
                for (String country : countries) {
                    filtered.add(new FilterTypeResult(1, country, 0));
                }
            }
            results.values = filtered;
            results.count = filtered.size();
            return results;
        }

        private boolean isStartingInitialsFor(String prefixString, String string2) {
            int initialLen = prefixString.length();
            int strLen = string2.length();
            int initialIdx = 0;
            boolean wasWordBreak = true;
            for (int i = 0; i < strLen; ++i) {
                if (!Character.isLetter(string2.charAt(i))) {
                    wasWordBreak = true;
                    continue;
                }
                if (!wasWordBreak) continue;
                if (prefixString.charAt(initialIdx++) != string2.charAt(i)) {
                    return false;
                }
                if (initialIdx == initialLen) {
                    return true;
                }
                wasWordBreak = false;
            }
            return prefixString.equals("usa") && string2.equals("united states");
        }

        private void handleSearchByGmt(ArrayList<FilterTypeResult> filtered, int num, boolean positiveOnly) {
            FilterTypeResult r;
            int i;
            if (num >= 0) {
                if (num == 1) {
                    for (i = 19; i >= 10; --i) {
                        if (!TimeZoneFilterTypeAdapter.this.mTimeZoneData.hasTimeZonesInHrOffset(i)) continue;
                        r = new FilterTypeResult(3, "GMT+" + i, i);
                        filtered.add(r);
                    }
                }
                if (TimeZoneFilterTypeAdapter.this.mTimeZoneData.hasTimeZonesInHrOffset(num)) {
                    r = new FilterTypeResult(3, "GMT+" + num, num);
                    filtered.add(r);
                }
                num *= -1;
            }
            if (!positiveOnly && num != 0) {
                if (TimeZoneFilterTypeAdapter.this.mTimeZoneData.hasTimeZonesInHrOffset(num)) {
                    r = new FilterTypeResult(3, "GMT" + num, num);
                    filtered.add(r);
                }
                if (num == -1) {
                    for (i = -10; i >= -19; --i) {
                        if (!TimeZoneFilterTypeAdapter.this.mTimeZoneData.hasTimeZonesInHrOffset(i)) continue;
                        r = new FilterTypeResult(3, "GMT" + i, i);
                        filtered.add(r);
                    }
                }
            }
        }

        public int parseNum(String str, int startIndex) {
            int idx = startIndex;
            int num = Integer.MIN_VALUE;
            int negativeMultiplier = 1;
            char ch = str.charAt(idx++);
            switch (ch) {
                case '-': {
                    negativeMultiplier = -1;
                }
                case '+': {
                    if (idx >= str.length()) {
                        return Integer.MIN_VALUE;
                    }
                    ch = str.charAt(idx++);
                }
            }
            if (!Character.isDigit(ch)) {
                return Integer.MIN_VALUE;
            }
            num = Character.digit(ch, 10);
            if (idx < str.length()) {
                if (Character.isDigit(ch = str.charAt(idx++))) {
                    num = 10 * num + Character.digit(ch, 10);
                } else {
                    return Integer.MIN_VALUE;
                }
            }
            if (idx != str.length()) {
                return Integer.MIN_VALUE;
            }
            return negativeMultiplier * num;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            if (results.values == null || results.count == 0) {
                if (TimeZoneFilterTypeAdapter.this.mListener != null) {
                    int filterType = TextUtils.isEmpty((CharSequence)constraint) ? 0 : -1;
                    TimeZoneFilterTypeAdapter.this.mListener.onSetFilter(filterType, null, 0);
                }
            } else {
                TimeZoneFilterTypeAdapter.this.mLiveResults = (ArrayList)results.values;
            }
            TimeZoneFilterTypeAdapter.this.mLiveResultsCount = results.count;
            if (results.count > 0) {
                TimeZoneFilterTypeAdapter.this.notifyDataSetChanged();
            } else {
                TimeZoneFilterTypeAdapter.this.notifyDataSetInvalidated();
            }
        }
    }

    class FilterTypeResult {
        int type;
        String constraint;
        public int time;

        public FilterTypeResult(int type, String constraint, int time) {
            this.type = type;
            this.constraint = constraint;
            this.time = time;
        }

        public String toString() {
            return this.constraint;
        }
    }

    static class ViewHolder {
        int filterType;
        String str;
        int time;
        TextView strTextView;

        ViewHolder() {
        }

        static void setupViewHolder(View v) {
            ViewHolder vh = new ViewHolder();
            vh.strTextView = (TextView)v.findViewById(R.id.value);
            v.setTag((Object)vh);
        }
    }

    public static interface OnSetFilterListener {
        public void onSetFilter(int var1, String var2, int var3);
    }
}

