/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.Spannable;
import android.text.format.Time;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import com.codetroopers.betterpickers.R;
import java.util.Locale;
import java.util.TimeZone;

public class TimeZonePickerUtils {
    private static final String TAG = "TimeZonePickerUtils";
    public static final int GMT_TEXT_COLOR = -7829368;
    public static final int DST_SYMBOL_COLOR = -4210753;
    private static final Spannable.Factory mSpannableFactory = Spannable.Factory.getInstance();
    private Locale mDefaultLocale;
    private String[] mOverrideIds;
    private String[] mOverrideLabels;

    public TimeZonePickerUtils(Context context) {
        this.cacheOverrides(context);
    }

    public CharSequence getGmtDisplayName(Context context, String id2, long millis, boolean grayGmt) {
        TimeZone timezone = TimeZone.getTimeZone(id2);
        if (timezone == null) {
            return null;
        }
        Locale defaultLocale = Locale.getDefault();
        if (!defaultLocale.equals(this.mDefaultLocale)) {
            this.mDefaultLocale = defaultLocale;
            this.cacheOverrides(context);
        }
        return this.buildGmtDisplayName(timezone, millis, grayGmt);
    }

    private CharSequence buildGmtDisplayName(TimeZone tz, long timeMillis, boolean grayGmt) {
        Time time = new Time(tz.getID());
        time.set(timeMillis);
        StringBuilder sb = new StringBuilder();
        String displayName = this.getDisplayName(tz, time.isDst != 0);
        sb.append(displayName);
        sb.append("  ");
        int gmtOffset = tz.getOffset(timeMillis);
        int gmtStart = sb.length();
        TimeZonePickerUtils.appendGmtOffset(sb, gmtOffset);
        int gmtEnd = sb.length();
        int symbolStart = 0;
        int symbolEnd = 0;
        if (tz.useDaylightTime()) {
            sb.append(" ");
            symbolStart = sb.length();
            sb.append(TimeZonePickerUtils.getDstSymbol());
            symbolEnd = sb.length();
        }
        Spannable spannableText = mSpannableFactory.newSpannable((CharSequence)sb);
        if (grayGmt) {
            spannableText.setSpan((Object)new ForegroundColorSpan(-7829368), gmtStart, gmtEnd, 33);
        }
        if (tz.useDaylightTime()) {
            spannableText.setSpan((Object)new ForegroundColorSpan(-4210753), symbolStart, symbolEnd, 33);
        }
        Spannable gmtDisplayName = spannableText;
        return gmtDisplayName;
    }

    public static void appendGmtOffset(StringBuilder sb, int gmtOffset) {
        sb.append("GMT");
        if (gmtOffset < 0) {
            sb.append('-');
        } else {
            sb.append('+');
        }
        int p = Math.abs(gmtOffset);
        sb.append((long)p / 3600000L);
        int min = p / 60000 % 60;
        if (min != 0) {
            sb.append(':');
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
        }
    }

    public static char getDstSymbol() {
        if (Build.VERSION.SDK_INT >= 16) {
            return '\u2600';
        }
        return '*';
    }

    private String getDisplayName(TimeZone tz, boolean daylightTime) {
        if (this.mOverrideIds == null || this.mOverrideLabels == null) {
            return tz.getDisplayName(daylightTime, 1, Locale.getDefault());
        }
        for (int i = 0; i < this.mOverrideIds.length; ++i) {
            if (!tz.getID().equals(this.mOverrideIds[i])) continue;
            if (this.mOverrideLabels.length > i) {
                return this.mOverrideLabels[i];
            }
            Log.e((String)TAG, (String)("timezone_rename_ids len=" + this.mOverrideIds.length + " timezone_rename_labels len=" + this.mOverrideLabels.length));
            break;
        }
        return tz.getDisplayName(daylightTime, 1, Locale.getDefault());
    }

    private void cacheOverrides(Context context) {
        Resources res = context.getResources();
        this.mOverrideIds = res.getStringArray(R.array.timezone_rename_ids);
        this.mOverrideLabels = res.getStringArray(R.array.timezone_rename_labels);
    }
}

