/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneData;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneFilterTypeAdapter;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneInfo;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneResultAdapter;

public class TimeZonePickerView
extends LinearLayout
implements TextWatcher,
AdapterView.OnItemClickListener,
View.OnClickListener {
    private static final String TAG = "TimeZonePickerView";
    private Typeface mSansSerifLightTypeface;
    private Context mContext;
    private AutoCompleteTextView mAutoCompleteTextView;
    private TimeZoneFilterTypeAdapter mFilterAdapter;
    private boolean mHideFilterSearchOnStart = false;
    private boolean mFirstTime = true;
    TimeZoneResultAdapter mResultAdapter;
    private ImageButton mClearButton;

    public TimeZonePickerView(Context context, AttributeSet attrs, String timeZone, long timeMillis, OnTimeZoneSetListener l, boolean hideFilterSearch) {
        super(context, attrs);
        this.mContext = context;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.timezonepickerview, (ViewGroup)this, true);
        this.mSansSerifLightTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Roboto-Light.ttf");
        this.mHideFilterSearchOnStart = hideFilterSearch;
        TimeZoneData tzd = new TimeZoneData(this.mContext, timeZone, timeMillis);
        this.mResultAdapter = new TimeZoneResultAdapter(this.mContext, tzd, l);
        ListView timeZoneList = (ListView)this.findViewById(R.id.timezonelist);
        timeZoneList.setAdapter((ListAdapter)this.mResultAdapter);
        timeZoneList.setOnItemClickListener((AdapterView.OnItemClickListener)this.mResultAdapter);
        this.mFilterAdapter = new TimeZoneFilterTypeAdapter(this.mContext, tzd, this.mResultAdapter);
        this.mAutoCompleteTextView = (AutoCompleteTextView)this.findViewById(R.id.searchBox);
        this.mAutoCompleteTextView.setTypeface(this.mSansSerifLightTypeface);
        this.mAutoCompleteTextView.addTextChangedListener((TextWatcher)this);
        this.mAutoCompleteTextView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mAutoCompleteTextView.setOnClickListener((View.OnClickListener)this);
        this.updateHint(R.string.hint_time_zone_search, R.drawable.ic_search_holo_light);
        this.mClearButton = (ImageButton)this.findViewById(R.id.clear_search);
        this.mClearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimeZonePickerView.this.mAutoCompleteTextView.getEditableText().clear();
            }
        });
    }

    public void showFilterResults(int type, String string2, int time) {
        if (this.mResultAdapter != null) {
            this.mResultAdapter.onSetFilter(type, string2, time);
        }
    }

    public boolean hasResults() {
        return this.mResultAdapter != null && this.mResultAdapter.hasResults();
    }

    public int getLastFilterType() {
        return this.mResultAdapter != null ? this.mResultAdapter.getLastFilterType() : -1;
    }

    public String getLastFilterString() {
        return this.mResultAdapter != null ? this.mResultAdapter.getLastFilterString() : null;
    }

    public int getLastFilterTime() {
        return this.mResultAdapter != null ? this.mResultAdapter.getLastFilterType() : -1;
    }

    public boolean getHideFilterSearchOnStart() {
        return this.mHideFilterSearchOnStart;
    }

    private void updateHint(int hintTextId, int imageDrawableId) {
        String hintText = this.getResources().getString(hintTextId);
        Drawable searchIcon = this.getResources().getDrawable(imageDrawableId);
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)"   ");
        ssb.append((CharSequence)hintText);
        int textSize = (int)((double)this.mAutoCompleteTextView.getTextSize() * 1.25);
        searchIcon.setBounds(0, 0, textSize, textSize);
        ssb.setSpan((Object)new ImageSpan(searchIcon), 1, 2, 33);
        this.mAutoCompleteTextView.setHint((CharSequence)ssb);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mFirstTime && this.mHideFilterSearchOnStart) {
            this.mFirstTime = false;
            return;
        }
        this.filterOnString(s.toString());
    }

    public void afterTextChanged(Editable s) {
        if (this.mClearButton != null) {
            this.mClearButton.setVisibility(s.length() > 0 ? 0 : 8);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        InputMethodManager manager = (InputMethodManager)this.getContext().getSystemService("input_method");
        manager.hideSoftInputFromWindow(this.mAutoCompleteTextView.getWindowToken(), 0);
        this.mHideFilterSearchOnStart = true;
        this.mFilterAdapter.onClick(view);
    }

    public void onClick(View v) {
        if (this.mAutoCompleteTextView != null && !this.mAutoCompleteTextView.isPopupShowing()) {
            this.filterOnString(this.mAutoCompleteTextView.getText().toString());
        }
    }

    private void filterOnString(String string2) {
        if (this.mAutoCompleteTextView.getAdapter() == null) {
            this.mAutoCompleteTextView.setAdapter((ListAdapter)this.mFilterAdapter);
        }
        this.mHideFilterSearchOnStart = false;
        this.mFilterAdapter.getFilter().filter((CharSequence)string2);
    }

    public static interface OnTimeZoneSetListener {
        public void onTimeZoneSet(TimeZoneInfo var1);
    }
}

