/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneData;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneFilterTypeAdapter;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneInfo;
import com.codetroopers.betterpickers.timezonepicker.TimeZonePickerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class TimeZoneResultAdapter
extends BaseAdapter
implements AdapterView.OnItemClickListener,
TimeZoneFilterTypeAdapter.OnSetFilterListener {
    private static final String TAG = "TimeZoneResultAdapter";
    private static final boolean DEBUG = false;
    private static final int VIEW_TAG_TIME_ZONE = R.id.time_zone;
    private static final int EMPTY_INDEX = -100;
    private Typeface mSansSerifLightTypeface;
    private static final String SHARED_PREFS_NAME = "com.android.calendar_preferences";
    private static final String KEY_RECENT_TIMEZONES = "preferences_recent_timezones";
    private int mLastFilterType;
    private String mLastFilterString;
    private int mLastFilterTime;
    private boolean mHasResults = false;
    private static final String RECENT_TIMEZONES_DELIMITER = ",";
    private static final int MAX_RECENT_TIMEZONES = 3;
    private Context mContext;
    private LayoutInflater mInflater;
    private TimeZonePickerView.OnTimeZoneSetListener mTimeZoneSetListener;
    private TimeZoneData mTimeZoneData;
    private int[] mFilteredTimeZoneIndices;
    private int mFilteredTimeZoneLength = 0;

    public TimeZoneResultAdapter(Context context, TimeZoneData tzd, TimeZonePickerView.OnTimeZoneSetListener l) {
        this.mContext = context;
        this.mTimeZoneData = tzd;
        this.mTimeZoneSetListener = l;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mFilteredTimeZoneIndices = new int[this.mTimeZoneData.size()];
        this.mSansSerifLightTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Roboto-Light.ttf");
        this.onSetFilter(0, null, 0);
    }

    public boolean hasResults() {
        return this.mHasResults;
    }

    public int getLastFilterType() {
        return this.mLastFilterType;
    }

    public String getLastFilterString() {
        return this.mLastFilterString;
    }

    public int getLastFilterTime() {
        return this.mLastFilterTime;
    }

    @Override
    public void onSetFilter(int filterType, String str, int time) {
        this.mLastFilterType = filterType;
        this.mLastFilterString = str;
        this.mLastFilterTime = time;
        this.mFilteredTimeZoneLength = 0;
        boolean idx = false;
        switch (filterType) {
            case -1: {
                this.mFilteredTimeZoneIndices[this.mFilteredTimeZoneLength++] = -100;
                break;
            }
            case 0: {
                SharedPreferences prefs;
                String recentsString;
                int defaultTzIndex = this.mTimeZoneData.getDefaultTimeZoneIndex();
                if (defaultTzIndex != -1) {
                    this.mFilteredTimeZoneIndices[this.mFilteredTimeZoneLength++] = defaultTzIndex;
                }
                if (TextUtils.isEmpty((CharSequence)(recentsString = (prefs = this.mContext.getSharedPreferences(SHARED_PREFS_NAME, 0)).getString(KEY_RECENT_TIMEZONES, null)))) break;
                String[] recents = recentsString.split(RECENT_TIMEZONES_DELIMITER);
                for (int i = recents.length - 1; i >= 0; --i) {
                    int index;
                    if (TextUtils.isEmpty((CharSequence)recents[i]) || recents[i].equals(this.mTimeZoneData.mDefaultTimeZoneId) || (index = this.mTimeZoneData.findIndexByTimeZoneIdSlow(recents[i])) == -1) continue;
                    this.mFilteredTimeZoneIndices[this.mFilteredTimeZoneLength++] = index;
                }
                break;
            }
            case 3: {
                ArrayList<Integer> indices = this.mTimeZoneData.getTimeZonesByOffset(time);
                if (indices == null) break;
                for (Integer i : indices) {
                    this.mFilteredTimeZoneIndices[this.mFilteredTimeZoneLength++] = i;
                }
                break;
            }
            case 1: {
                ArrayList<Integer> tzIds = this.mTimeZoneData.mTimeZonesByCountry.get(str);
                if (tzIds == null) break;
                for (Integer tzi : tzIds) {
                    this.mFilteredTimeZoneIndices[this.mFilteredTimeZoneLength++] = tzi;
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mHasResults = this.mFilteredTimeZoneLength > 0;
        this.notifyDataSetChanged();
    }

    public void saveRecentTimezone(String id2) {
        SharedPreferences prefs = this.mContext.getSharedPreferences(SHARED_PREFS_NAME, 0);
        String recentsString = prefs.getString(KEY_RECENT_TIMEZONES, null);
        if (recentsString == null) {
            recentsString = id2;
        } else {
            LinkedHashSet<String> recents = new LinkedHashSet<String>();
            for (String tzId : recentsString.split(RECENT_TIMEZONES_DELIMITER)) {
                if (recents.contains(tzId) || id2.equals(tzId)) continue;
                recents.add(tzId);
            }
            Iterator it = recents.iterator();
            while (recents.size() >= 3 && it.hasNext()) {
                it.next();
                it.remove();
            }
            recents.add(id2);
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String recent : recents) {
                if (first) {
                    first = false;
                } else {
                    builder.append(RECENT_TIMEZONES_DELIMITER);
                }
                builder.append(recent);
            }
            recentsString = builder.toString();
        }
        prefs.edit().putString(KEY_RECENT_TIMEZONES, recentsString).apply();
    }

    public int getCount() {
        return this.mFilteredTimeZoneLength;
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.mFilteredTimeZoneLength) {
            return null;
        }
        return this.mTimeZoneData.get(this.mFilteredTimeZoneIndices[position]);
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        return this.mFilteredTimeZoneIndices[position] >= 0;
    }

    public long getItemId(int position) {
        return this.mFilteredTimeZoneIndices[position];
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        if (this.mFilteredTimeZoneIndices[position] == -100) {
            v = this.mInflater.inflate(R.layout.empty_time_zone_item, parent, false);
            ((TextView)v.findViewById(R.id.empty_item)).setTypeface(this.mSansSerifLightTypeface);
            return v;
        }
        if (v == null || v.findViewById(R.id.empty_item) != null) {
            v = this.mInflater.inflate(R.layout.time_zone_item, parent, false);
            ViewHolder.setupViewHolder(v);
        }
        ViewHolder vh = (ViewHolder)v.getTag();
        TimeZoneInfo tzi = this.mTimeZoneData.get(this.mFilteredTimeZoneIndices[position]);
        v.setTag(VIEW_TAG_TIME_ZONE, (Object)tzi);
        vh.timeZone.setTypeface(this.mSansSerifLightTypeface);
        vh.timeOffset.setTypeface(this.mSansSerifLightTypeface);
        vh.location.setTypeface(this.mSansSerifLightTypeface);
        vh.timeZone.setText((CharSequence)tzi.mDisplayName);
        vh.timeOffset.setText(tzi.getGmtDisplayName(this.mContext));
        String location = tzi.mCountry;
        if (location == null) {
            vh.location.setVisibility(4);
        } else {
            vh.location.setText((CharSequence)location);
            vh.location.setVisibility(0);
        }
        return v;
    }

    public boolean hasStableIds() {
        return true;
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        TimeZoneInfo tzi;
        if (this.mTimeZoneSetListener != null && (tzi = (TimeZoneInfo)v.getTag(VIEW_TAG_TIME_ZONE)) != null) {
            this.mTimeZoneSetListener.onTimeZoneSet(tzi);
            this.saveRecentTimezone(tzi.mTzId);
        }
    }

    static class ViewHolder {
        TextView timeZone;
        TextView timeOffset;
        TextView location;

        ViewHolder() {
        }

        static void setupViewHolder(View v) {
            ViewHolder vh = new ViewHolder();
            vh.timeZone = (TextView)v.findViewById(R.id.time_zone);
            vh.timeOffset = (TextView)v.findViewById(R.id.time_offset);
            vh.location = (TextView)v.findViewById(R.id.location);
            v.setTag((Object)vh);
        }
    }
}

