/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;

public class ZeroTopPaddingTextView
extends TextView {
    private static final float NORMAL_FONT_PADDING_RATIO = 0.328f;
    private static final float BOLD_FONT_PADDING_RATIO = 0.208f;
    private static final float NORMAL_FONT_BOTTOM_PADDING_RATIO = 0.25f;
    private static final float BOLD_FONT_BOTTOM_PADDING_RATIO = 0.208f;
    private static final float PRE_ICS_BOTTOM_PADDING_RATIO = 0.233f;
    private static final Typeface SAN_SERIF_BOLD = Typeface.create((String)"san-serif", (int)1);
    private static final Typeface SAN_SERIF_CONDENSED_BOLD = Typeface.create((String)"sans-serif-condensed", (int)1);
    private int mPaddingRight = 0;
    private String decimalSeperator = "";
    private String timeSeperator = "";

    public ZeroTopPaddingTextView(Context context) {
        this(context, null);
    }

    public ZeroTopPaddingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ZeroTopPaddingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this.setIncludeFontPadding(false);
        this.updatePadding();
    }

    private void init() {
        this.decimalSeperator = this.getResources().getString(R.string.number_picker_seperator);
        this.timeSeperator = this.getResources().getString(R.string.time_picker_time_seperator);
    }

    public void updatePadding() {
        float paddingRatio = 0.328f;
        float bottomPaddingRatio = 0.25f;
        if (this.getPaint().getTypeface() != null && this.getPaint().getTypeface().equals((Object)Typeface.DEFAULT_BOLD)) {
            paddingRatio = 0.208f;
            bottomPaddingRatio = 0.208f;
        }
        if (this.getTypeface() != null && this.getTypeface().equals((Object)SAN_SERIF_BOLD)) {
            paddingRatio = 0.208f;
            bottomPaddingRatio = 0.208f;
        }
        if (this.getTypeface() != null && this.getTypeface().equals((Object)SAN_SERIF_CONDENSED_BOLD)) {
            paddingRatio = 0.208f;
            bottomPaddingRatio = 0.208f;
        }
        if (Build.VERSION.SDK_INT < 14 && this.getText() != null && (this.getText().toString().equals(this.decimalSeperator) || this.getText().toString().equals(this.timeSeperator))) {
            bottomPaddingRatio = 0.233f;
        }
        this.setPadding(0, (int)(-paddingRatio * this.getTextSize()), this.mPaddingRight, (int)(-bottomPaddingRatio * this.getTextSize()));
    }

    public void updatePaddingForBoldDate() {
        float paddingRatio = 0.208f;
        float bottomPaddingRatio = 0.208f;
        this.setPadding(0, (int)(-paddingRatio * this.getTextSize()), this.mPaddingRight, (int)(-bottomPaddingRatio * this.getTextSize()));
    }

    public void setPaddingRight(int padding) {
        this.mPaddingRight = padding;
        this.updatePadding();
    }
}

