/*
 * Decompiled with CFR 0.152.
 */
package codetroopers.wicket.web.daterangepicker;

import codetroopers.wicket.web.daterangepicker.DatePairConverter;
import codetroopers.wicket.web.daterangepicker.DateRangePair;
import codetroopers.wicket.web.daterangepicker.javascript.DateRangePickerOptions;
import codetroopers.wicket.web.daterangepicker.javascript.DateRangePickerReference;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRangePickerBehavior
extends Behavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateRangePickerBehavior.class);

    public void bind(Component component) {
        super.bind(component);
        if (!(component instanceof TextField)) {
            component.remove(new Behavior[]{this});
            throw new WicketRuntimeException("DateRangePickerBehavior must be bound to a Textfield");
        }
        IConverterLocator converterLocator = component.getApplication().getConverterLocator();
        if (converterLocator instanceof ConverterLocator) {
            IConverter converter = ((ConverterLocator)converterLocator).get(DateRangePair.class);
            if (converter == null) {
                LOGGER.info("There is no DateRangePair converter registered in the application, trying to register one...");
                ((ConverterLocator)converterLocator).set(DateRangePair.class, (IConverter)new DatePairConverter());
            }
        } else {
            LOGGER.error("Can't automatically verify DateRangePair converter presence ! (custom ConverterLocator is used)");
        }
        component.setOutputMarkupId(true);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new DateRangePickerReference()));
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.buildScript(component)));
    }

    private CharSequence buildScript(Component component) {
        StringBuilder stringBuilder = new StringBuilder();
        this.setMomentLocale(component, stringBuilder);
        return stringBuilder.append("$('#").append(component.getMarkupId()).append("').daterangepicker(").append(DateRangePickerBehavior.toJson(this.getPickerOptions(component))).append(");");
    }

    protected void setMomentLocale(Component component, StringBuilder stringBuilder) {
        if (Locale.FRENCH.getLanguage().equals(component.getLocale().getLanguage())) {
            stringBuilder.append("moment.lang('fr');");
        } else {
            stringBuilder.append("moment.lang('en');");
        }
    }

    protected DateRangePickerOptions getPickerOptions(Component component) {
        if (Locale.FRENCH.getLanguage().equals(component.getLocale().getLanguage())) {
            return DateRangePickerOptions.getDefaultFrench();
        }
        return DateRangePickerOptions.getDefaultEnglish();
    }

    private static JsonNode toJson(DateRangePickerOptions pickerOptions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return mapper.valueToTree((Object)pickerOptions);
    }
}

