/*
 * Decompiled with CFR 0.152.
 */
package codetroopers.wicket.web.daterangepicker.javascript;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class DateRangePickerOptions
implements Serializable {
    private String format;
    private String applyClass;
    private String clearClass;
    private Date startDate;
    private Date endDate;
    private Date minDate;
    private Date maxDate;
    private Map<String, Date[]> ranges;
    private Date dateLimit;
    private String opens;
    private String showWeekNumbers;
    private String buttonClasses;
    private Boolean showDropdowns;
    private Boolean dropDownAdjusts;
    private final LocaleOptions locale = new LocaleOptions();

    public DateRangePickerOptions(String format) {
        this.format = format;
    }

    public static DateRangePickerOptions getDefaultFrench() {
        DateRangePickerOptions pickerOptions = new DateRangePickerOptions("DD/MM/YY");
        pickerOptions.getLocale().setApplyLabel("Appliquer").setClearLabel("Effacer").setFromLabel("Du").setToLabel("au").setWeekLabel("Sem.").setCustomRange("Plage perso.");
        return pickerOptions;
    }

    public static DateRangePickerOptions getDefaultEnglish() {
        return new DateRangePickerOptions("MM/DD/YY");
    }

    public String getApplyClass() {
        return this.applyClass;
    }

    public void setApplyClass(String applyClass) {
        this.applyClass = applyClass;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public LocaleOptions getLocale() {
        return this.locale;
    }

    public String getClearClass() {
        return this.clearClass;
    }

    public void setClearClass(String clearClass) {
        this.clearClass = clearClass;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Map<String, Date[]> getRanges() {
        return this.ranges;
    }

    public DateRangePickerOptions addRange(String name, Date startDate, Date endDate) {
        if (this.ranges == null) {
            this.ranges = new LinkedHashMap<String, Date[]>();
        }
        this.ranges.put(name, new Date[]{startDate, endDate});
        return this;
    }

    public Date getDateLimit() {
        return this.dateLimit;
    }

    public void setDateLimit(Date dateLimit) {
        this.dateLimit = dateLimit;
    }

    public String getOpens() {
        return this.opens;
    }

    public void setOpens(String opens) {
        this.opens = opens;
    }

    public String getShowWeekNumbers() {
        return this.showWeekNumbers;
    }

    public void setShowWeekNumbers(String showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
    }

    public String getButtonClasses() {
        return this.buttonClasses;
    }

    public void setButtonClasses(String buttonClasses) {
        this.buttonClasses = buttonClasses;
    }

    public Boolean getShowDropdowns() {
        return this.showDropdowns;
    }

    public void setShowDropdowns(Boolean showDropdowns) {
        this.showDropdowns = showDropdowns;
    }

    public Boolean getDropDownAdjusts() {
        return this.dropDownAdjusts;
    }

    public void setDropDownAdjusts(Boolean dropDownAdjusts) {
        this.dropDownAdjusts = dropDownAdjusts;
    }

    public static class LocaleOptions
    implements Serializable {
        private String applyLabel;
        private String clearLabel;
        private String fromLabel;
        private String toLabel;
        private String weekLabel;
        private String customRange;

        public String getApplyLabel() {
            return this.applyLabel;
        }

        public LocaleOptions setApplyLabel(String applyLabel) {
            this.applyLabel = applyLabel;
            return this;
        }

        public String getClearLabel() {
            return this.clearLabel;
        }

        public LocaleOptions setClearLabel(String clearLabel) {
            this.clearLabel = clearLabel;
            return this;
        }

        public String getFromLabel() {
            return this.fromLabel;
        }

        public LocaleOptions setFromLabel(String fromLabel) {
            this.fromLabel = fromLabel;
            return this;
        }

        public String getToLabel() {
            return this.toLabel;
        }

        public LocaleOptions setToLabel(String toLabel) {
            this.toLabel = toLabel;
            return this;
        }

        public String getWeekLabel() {
            return this.weekLabel;
        }

        public LocaleOptions setWeekLabel(String weekLabel) {
            this.weekLabel = weekLabel;
            return this;
        }

        public String getCustomRange() {
            return this.customRange;
        }

        public LocaleOptions setCustomRange(String customRange) {
            this.customRange = customRange;
            return this;
        }
    }
}

