package codetroopers.wicket.web.datagrid.column;

import codetroopers.wicket.web.datagrid.component.EditableDataTable;
import codetroopers.wicket.web.datagrid.component.EditableGridSubmitLink;
import codetroopers.wicket.web.datagrid.model.GridOperationData;
import codetroopers.wicket.web.datagrid.model.OperationType;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;

/**
 *
 * @author Nadeem Mohammad
 *
 */
public abstract class EditableGridActionsPanel<T> extends Panel {
    public final static MetaDataKey<Boolean> EDITING = new MetaDataKey<Boolean>() {
        private static final long serialVersionUID = 1L;
    };

    private static final long serialVersionUID = 1L;

    protected abstract void onSave(AjaxRequestTarget target);

    protected abstract void onError(AjaxRequestTarget target);

    protected abstract void onCancel(AjaxRequestTarget target);

    protected abstract void onDelete(AjaxRequestTarget target);

    public EditableGridActionsPanel(String id, final Item<ICellPopulator<T>> cellItem) {
        super(id);

        @SuppressWarnings("unchecked")
        final Item<T> rowItem = cellItem.findParent(Item.class);

        add(newEditLink(rowItem));
        add(newSaveLink(rowItem));
        add(newCancelLink(rowItem));
        add(newDeleteLink(rowItem));
    }

    private EditableGridSubmitLink newSaveLink(final Item<T> rowItem) {
        return new EditableGridSubmitLink("save", rowItem) {

            private static final long serialVersionUID = 1L;

            @Override
            public boolean isVisible() {
                return isThisRowBeingEdited(rowItem);
            }

            @Override
            protected void onSuccess(AjaxRequestTarget target) {
                rowItem.setMetaData(EDITING, Boolean.FALSE);
                send(getPage(), Broadcast.BREADTH, rowItem);
                target.add(rowItem);
                onSave(target);

            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableGridActionsPanel.this.onError(target);
            }
        };
    }

    private AjaxLink<String> newDeleteLink(final Item<T> rowItem) {
        return new AjaxLink<String>("delete") {

            private static final long serialVersionUID = 1L;


            @SuppressWarnings("unchecked")
            @Override
            public void onClick(AjaxRequestTarget target) {
                send(getPage(), Broadcast.BREADTH, new GridOperationData<>(OperationType.DELETE,
                                                                            (T) rowItem.getDefaultModelObject()));
                target.add(rowItem.findParent(EditableDataTable.class));
                onDelete(target);
            }
        };
    }

    private AjaxLink<String> newCancelLink(final Item<T> rowItem) {
        return new AjaxLink<String>("cancel") {

            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                rowItem.setMetaData(EDITING, Boolean.FALSE);
                send(getPage(), Broadcast.BREADTH, rowItem);
                target.add(rowItem);
                onCancel(target);
            }

            @Override
            public boolean isVisible() {
                return isThisRowBeingEdited(rowItem);
            }
        };
    }

    private AjaxLink<String> newEditLink(final Item<T> rowItem) {
        return new AjaxLink<String>("edit") {

            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                rowItem.setMetaData(EDITING, Boolean.TRUE);
                send(getPage(), Broadcast.BREADTH, rowItem);
                target.add(rowItem);
            }

            @Override
            public boolean isVisible() {
                return !isThisRowBeingEdited(rowItem);
            }
        };
    }

    private boolean isThisRowBeingEdited(Item<T> rowItem) {
        return rowItem.getMetaData(EDITING);
    }
}
