/*
 * Decompiled with CFR 0.152.
 */
package codetroopers.wicket.web.datagrid;

import codetroopers.wicket.web.datagrid.column.EditableGridActionsColumn;
import codetroopers.wicket.web.datagrid.component.EditableDataTable;
import codetroopers.wicket.web.datagrid.js.EditableGridBehavior;
import codetroopers.wicket.web.datagrid.provider.IEditableDataProvider;
import codetroopers.wicket.web.datagrid.toolbar.EditableGridBottomToolbar;
import codetroopers.wicket.web.datagrid.toolbar.EditableGridHeadersToolbar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EditableGrid<T, S>
extends Panel {
    private static final long serialVersionUID = 1L;
    private EditableDataTable<T, S> dataTable;
    private FeedbackPanel feedback;

    public EditableGrid(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        super(id);
        ArrayList<Object> newCols = new ArrayList<Object>();
        newCols.addAll(columns);
        newCols.add(this.newActionsColumn());
        this.add(new Component[]{this.buildForm(newCols, dataProvider, rowsPerPage, clazz)});
        this.add(new Behavior[]{new EditableGridBehavior()});
    }

    private Component buildForm(List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        NonValidatingForm form = new NonValidatingForm("form");
        form.setOutputMarkupId(true);
        form.add(new Component[]{this.newDataTable(columns, dataProvider, rowsPerPage, clazz)});
        this.feedback = this.newFeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        form.add(new Component[]{this.feedback});
        return form;
    }

    protected FeedbackPanel newFeedbackPanel(String markupId) {
        return new FeedbackPanel(markupId);
    }

    private Component newDataTable(List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        this.dataTable = new EditableDataTable<T, S>("dataTable", columns, dataProvider, rowsPerPage, clazz){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableGrid.this.onError(target);
            }
        };
        this.dataTable.setOutputMarkupId(true);
        this.dataTable.addTopToolbar(new EditableGridHeadersToolbar<T, S>(this.dataTable, dataProvider));
        if (this.displayAddFeature()) {
            this.dataTable.addBottomToolbar(this.newAddBottomToolbar(dataProvider, clazz, this.dataTable));
        }
        return this.dataTable;
    }

    private EditableGridBottomToolbar<T, S> newAddBottomToolbar(final IEditableDataProvider<T, S> dataProvider, Class<T> clazz, final EditableDataTable<T, S> dataTable) {
        return new EditableGridBottomToolbar<T, S>(dataTable, clazz){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onAdd(AjaxRequestTarget target, T newRow) {
                dataProvider.add(newRow);
                target.add(new Component[]{dataTable});
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onAdd(target, newRow);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onError(target);
            }
        };
    }

    protected EditableGridActionsColumn<T, S> newActionsColumn() {
        return new EditableGridActionsColumn<T, S>((IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target, IModel<T> rowModel) {
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onError(target);
            }

            @Override
            protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onSave(target, rowModel);
            }

            @Override
            protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onDelete(target, rowModel);
            }

            @Override
            protected void onCancel(AjaxRequestTarget target) {
                target.add(new Component[]{EditableGrid.this.feedback});
                EditableGrid.this.onCancel(target);
            }
        };
    }

    protected void onCancel(AjaxRequestTarget target) {
    }

    protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    protected void onAdd(AjaxRequestTarget target, T newRow) {
    }

    protected boolean displayAddFeature() {
        return true;
    }

    public EditableDataTable<T, S> getDataTable() {
        return this.dataTable;
    }

    private static class NonValidatingForm<T>
    extends Form<T> {
        private static final long serialVersionUID = 1L;

        public NonValidatingForm(String id) {
            super(id);
        }

        public void process(IFormSubmitter submittingComponent) {
            this.delegateSubmit(submittingComponent);
        }
    }
}

