/*
 * Decompiled with CFR 0.152.
 */
package codetroopers.wicket.web.datagrid.column;

import codetroopers.wicket.web.datagrid.component.EditableDataTable;
import codetroopers.wicket.web.datagrid.component.EditableGridSubmitLink;
import codetroopers.wicket.web.datagrid.model.GridOperationData;
import codetroopers.wicket.web.datagrid.model.OperationType;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;

public abstract class EditableGridActionsPanel<T>
extends Panel {
    public static final MetaDataKey<Boolean> EDITING = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private static final long serialVersionUID = 1L;

    protected abstract void onSave(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected abstract void onDelete(AjaxRequestTarget var1);

    public EditableGridActionsPanel(String id, Item<ICellPopulator<T>> cellItem) {
        super(id);
        Item rowItem = (Item)cellItem.findParent(Item.class);
        this.add(new Component[]{this.newEditLink(rowItem)});
        this.add(new Component[]{this.newSaveLink(rowItem)});
        this.add(new Component[]{this.newCancelLink(rowItem)});
        this.add(new Component[]{this.newDeleteLink(rowItem)});
    }

    private EditableGridSubmitLink newSaveLink(Item<T> rowItem) {
        return new EditableGridSubmitLink("save", (WebMarkupContainer)rowItem, (Item)rowItem){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ Item val$rowItem;
            {
                this.val$rowItem = item;
                super(x0, x1);
            }

            public boolean isVisible() {
                return EditableGridActionsPanel.this.isThisRowBeingEdited(this.val$rowItem);
            }

            @Override
            protected void onSuccess(AjaxRequestTarget target) {
                this.val$rowItem.setMetaData(EDITING, (Object)Boolean.FALSE);
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, this.val$rowItem);
                target.add(new Component[]{this.val$rowItem});
                EditableGridActionsPanel.this.onSave(target);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableGridActionsPanel.this.onError(target);
            }
        };
    }

    private AjaxLink<String> newDeleteLink(final Item<T> rowItem) {
        return new AjaxLink<String>("delete"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new GridOperationData<Object>(OperationType.DELETE, rowItem.getDefaultModelObject()));
                target.add(new Component[]{(Component)rowItem.findParent(EditableDataTable.class)});
                EditableGridActionsPanel.this.onDelete(target);
            }
        };
    }

    private AjaxLink<String> newCancelLink(final Item<T> rowItem) {
        return new AjaxLink<String>("cancel"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                rowItem.setMetaData(EDITING, (Object)Boolean.FALSE);
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, rowItem);
                target.add(new Component[]{rowItem});
                EditableGridActionsPanel.this.onCancel(target);
            }

            public boolean isVisible() {
                return EditableGridActionsPanel.this.isThisRowBeingEdited(rowItem);
            }
        };
    }

    private AjaxLink<String> newEditLink(final Item<T> rowItem) {
        return new AjaxLink<String>("edit"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                rowItem.setMetaData(EDITING, (Object)Boolean.TRUE);
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, rowItem);
                target.add(new Component[]{rowItem});
            }

            public boolean isVisible() {
                return !EditableGridActionsPanel.this.isThisRowBeingEdited(rowItem);
            }
        };
    }

    private boolean isThisRowBeingEdited(Item<T> rowItem) {
        return (Boolean)rowItem.getMetaData(EDITING);
    }
}

