/*
 * Decompiled with CFR 0.152.
 */
package codetroopers.wicket.web.datagrid.provider;

import codetroopers.wicket.web.datagrid.provider.IEditableDataProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EditableListDataProvider<T extends Serializable, S>
implements IEditableDataProvider<T, S> {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public EditableListDataProvider() {
        this(Collections.emptyList());
    }

    public EditableListDataProvider(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("argument [list] cannot be null");
        }
        this.list = list;
    }

    protected List<T> getData() {
        return this.list;
    }

    public Iterator<? extends T> iterator(long first, long count) {
        long toIndex = first + count;
        List<T> list = this.getData();
        if (toIndex > (long)list.size()) {
            toIndex = list.size();
        }
        return list.subList((int)first, (int)toIndex).listIterator();
    }

    public long size() {
        return this.getData().size();
    }

    public IModel<T> model(T object) {
        return new Model(object);
    }

    public void detach() {
    }

    @Override
    public void add(T item) {
        this.list.add(item);
    }

    @Override
    public void remove(T item) {
        this.list.remove(item);
    }

    public ISortState<S> getSortState() {
        return null;
    }
}

