/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph;

import com.code972.hebmorph.HebrewToken;
import com.code972.hebmorph.LookupTolerators;
import com.code972.hebmorph.MorphData;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.datastructures.DictRadix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Lemmatizer {
    private final DictHebMorph dictHeb;

    public Lemmatizer(DictHebMorph dict) {
        this.dictHeb = dict;
    }

    public boolean isLegalPrefix(String str) {
        return this.dictHeb.getPref().containsKey(str);
    }

    public String tryStrippingPrefix(String word) {
        int firstQuote = word.indexOf(34);
        if (firstQuote > -1 && firstQuote < word.length() - 2 && this.isLegalPrefix(word.substring(0, firstQuote))) {
            return word.substring(firstQuote + 1, firstQuote + 1 + word.length() - firstQuote - 1);
        }
        int firstSingleQuote = word.indexOf(39);
        if (firstSingleQuote == -1) {
            return word;
        }
        if (firstQuote > -1 && firstSingleQuote > firstQuote) {
            return word;
        }
        if (this.isLegalPrefix(word.substring(0, firstSingleQuote))) {
            return word.substring(firstSingleQuote + 1, firstSingleQuote + 1 + word.length() - firstSingleQuote - 1);
        }
        return word;
    }

    public static String removeNiqqud(String word) {
        int length = word.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (word.charAt(i) >= '\u05af' && word.charAt(i) <= '\u05c4') continue;
            sb.append(word.charAt(i));
        }
        return sb.toString();
    }

    public List<HebrewToken> lemmatize(String word) {
        return this.lemmatize(word, new ArrayList<HebrewToken>());
    }

    public List<HebrewToken> lemmatize(String word, List<HebrewToken> ret) {
        Integer prefixMask;
        byte prefLen = 0;
        MorphData md = null;
        HashMap<String, Integer> m_pref = this.dictHeb.getPref();
        try {
            md = this.dictHeb.lookup(word);
        }
        catch (IllegalArgumentException e) {
            md = null;
        }
        if (md != null) {
            for (int result = 0; result < md.getLemmas().length; ++result) {
                ret.add(new HebrewToken(word, 0, md.getLemmas()[result], 1.0f));
            }
        } else if (word.endsWith("'")) {
            try {
                md = this.dictHeb.lookup(word.substring(0, word.length() - 1));
            }
            catch (IllegalArgumentException e) {
                md = null;
            }
            if (md != null) {
                for (int result = 0; result < md.getLemmas().length; ++result) {
                    ret.add(new HebrewToken(word, 0, md.getLemmas()[result], 1.0f));
                }
            }
        }
        prefLen = 0;
        while (word.length() - prefLen >= 2 && (prefixMask = m_pref.get(word.substring(0, prefLen = (byte)((byte)(prefLen + 1))))) != null) {
            try {
                md = this.dictHeb.lookup(word.substring(prefLen));
            }
            catch (IllegalArgumentException e) {
                md = null;
            }
            if (md == null || (md.getPrefixes() & prefixMask) <= 0) continue;
            for (int result = 0; result < md.getLemmas().length; ++result) {
                if ((md.getLemmas()[result].getPrefix().getValue() & prefixMask) <= 0) continue;
                ret.add(new HebrewToken(word, prefLen, md.getLemmas()[result], 0.9f));
            }
        }
        return ret;
    }

    public List<HebrewToken> lemmatizeTolerant(String word) {
        return this.lemmatizeTolerant(word, new ArrayList<HebrewToken>());
    }

    public List<HebrewToken> lemmatizeTolerant(String word, List<HebrewToken> ret) {
        Integer prefixMask;
        int result;
        DictRadix<MorphData> m_dict = this.dictHeb.getRadix();
        HashMap<String, Integer> m_pref = this.dictHeb.getPref();
        if (word.length() > 20) {
            return ret;
        }
        byte prefLen = 0;
        List<DictRadix.LookupResult> tolerated = m_dict.lookupTolerant(word, LookupTolerators.TolerateEmKryiaAll);
        if (tolerated != null) {
            for (DictRadix.LookupResult lr : tolerated) {
                for (result = 0; result < ((MorphData)lr.getData()).getLemmas().length; ++result) {
                    ret.add(new HebrewToken(lr.getWord(), 0, ((MorphData)lr.getData()).getLemmas()[result], lr.getScore()));
                }
            }
        }
        prefLen = 0;
        while (word.length() - prefLen >= 2 && (prefixMask = m_pref.get(word.substring(0, prefLen = (byte)((byte)(prefLen + 1))))) != null) {
            tolerated = m_dict.lookupTolerant(word.substring(prefLen), LookupTolerators.TolerateEmKryiaAll);
            if (tolerated == null) continue;
            for (DictRadix.LookupResult lr : tolerated) {
                for (result = 0; result < ((MorphData)lr.getData()).getLemmas().length; ++result) {
                    if ((((MorphData)lr.getData()).getLemmas()[result].getPrefix().getValue() & prefixMask) <= 0) continue;
                    ret.add(new HebrewToken(word.substring(0, prefLen) + lr.getWord(), prefLen, ((MorphData)lr.getData()).getLemmas()[result], lr.getScore() * 0.9f));
                }
            }
        }
        return ret;
    }
}

