/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph.hspell;

import com.code972.hebmorph.DictionaryLoader;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.hspell.HSpellLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;

public class HSpellDictionaryLoader
implements DictionaryLoader {
    @Override
    public String dictionaryLoaderName() {
        return "hspell";
    }

    @Override
    public String[] dictionaryPossiblePaths() {
        return new String[]{Paths.get("plugins", "analysis-hebrew", "hspell-data-files").toString(), "/var/lib/hspell-data-files/"};
    }

    @Override
    public DictHebMorph loadDictionaryFromPath(String path) throws IOException {
        File file;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((file = new File(path)).isDirectory()) {
            HSpellLoader loader = new HSpellLoader(new File(path), true);
            return loader.loadDictionaryFromHSpellData(new FileInputStream(new File(path, "prefix_h.gz")));
        }
        throw new IOException("Expected a folder. Cannot load dictionary from HSpell files.");
    }

    @Override
    public DictHebMorph loadDictionaryFromDefaultPath() throws IOException {
        HSpellLoader loader = new HSpellLoader(new File(HSpellLoader.getHspellPath()), true);
        return loader.loadDictionaryFromHSpellData(new FileInputStream(new File(HSpellLoader.getHspellPath(), "prefix_noH.gz")));
    }

    public static void main(String[] args) {
        System.out.println(Paths.get("plugins", "analysis-hebrew", "hspell-data-files").toString());
    }
}

