/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import com.code972.hebmorph.HebrewUtils;
import com.code972.hebmorph.LookupTolerators;
import com.code972.hebmorph.MorphData;
import com.code972.hebmorph.WordType;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.datastructures.DictRadix;
import com.code972.hebmorph.hspell.HSpellDictionaryLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;

public abstract class HebrewAnalyzer
extends Analyzer {
    private static final Byte dummyData = 0;
    protected DictHebMorph dict;
    protected final char originalTermSuffix = (char)36;
    protected DictRadix<Byte> SPECIAL_TOKENIZATION_CASES = null;
    protected CharArraySet commonWords = null;

    public DictRadix<Byte> setCustomTokenizationCases(InputStream input) throws IOException {
        if (input != null) {
            CharArraySet wordsList = WordlistLoader.getSnowballWordSet((Reader)IOUtils.getDecodingReader((InputStream)input, (Charset)StandardCharsets.UTF_8));
            DictRadix<Byte> radix = new DictRadix<Byte>(false);
            for (Object aWordsList : wordsList) {
                radix.addNode((char[])aWordsList, dummyData);
            }
            this.SPECIAL_TOKENIZATION_CASES = radix;
        }
        return this.SPECIAL_TOKENIZATION_CASES;
    }

    protected HebrewAnalyzer(DictHebMorph dict) throws IOException {
        this.dict = dict;
    }

    public HebrewAnalyzer() throws IOException {
        this(new HSpellDictionaryLoader().loadDictionaryFromDefaultPath());
    }

    public static boolean isHebrewWord(CharSequence word) {
        for (int i = 0; i < word.length(); ++i) {
            if (!HebrewUtils.isHebrewLetter(word.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public WordType isRecognizedWord(String word, boolean tolerate) {
        return HebrewAnalyzer.isRecognizedWord(word, tolerate, this.dict);
    }

    public static WordType isRecognizedWord(String word, boolean tolerate, DictHebMorph dict) {
        Integer prefixMask;
        int prefLen = 0;
        HashMap<String, Integer> prefixesTree = dict.getPref();
        DictRadix<MorphData> dictRadix = dict.getRadix();
        if (!HebrewAnalyzer.isHebrewWord(word)) {
            return WordType.NON_HEBREW;
        }
        try {
            if (dict.lookup(word) != null) {
                return WordType.HEBREW;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (word.endsWith("'")) {
            try {
                if (dict.lookup(word.substring(0, word.length() - 1)) != null) {
                    return WordType.HEBREW;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        prefLen = 0;
        while (word.length() - prefLen >= 2 && (prefixMask = prefixesTree.get(word.substring(0, prefLen = (int)((byte)(prefLen + 1))))) != null) {
            MorphData md;
            try {
                md = dict.lookup(word.substring(prefLen));
            }
            catch (IllegalArgumentException e) {
                md = null;
            }
            if (md == null || (md.getPrefixes() & prefixMask) <= 0) continue;
            for (int result = 0; result < md.getLemmas().length; ++result) {
                if ((md.getLemmas()[result].getPrefix().getValue() & prefixMask) <= 0) continue;
                return WordType.HEBREW_WITH_PREFIX;
            }
        }
        if (tolerate) {
            if (word.length() > 19) {
                return WordType.UNRECOGNIZED;
            }
            List<DictRadix.LookupResult> tolerated = dictRadix.lookupTolerant(word, LookupTolerators.TolerateEmKryiaAll);
            if (tolerated != null && tolerated.size() > 0) {
                return WordType.HEBREW_TOLERATED;
            }
            prefLen = 0;
            while (word.length() - prefLen >= 2 && (prefixMask = prefixesTree.get(word.substring(0, prefLen = (int)((byte)(prefLen + 1))))) != null) {
                tolerated = dictRadix.lookupTolerant(word.substring(prefLen), LookupTolerators.TolerateEmKryiaAll);
                if (tolerated == null) continue;
                for (DictRadix.LookupResult lr : tolerated) {
                    for (int result = 0; result < ((MorphData)lr.getData()).getLemmas().length; ++result) {
                        if ((((MorphData)lr.getData()).getLemmas()[result].getPrefix().getValue() & prefixMask) <= 0) continue;
                        return WordType.HEBREW_TOLERATED_WITH_PREFIX;
                    }
                }
            }
        }
        return WordType.UNRECOGNIZED;
    }
}

