/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import org.apache.lucene.analysis.hebrew.HebrewTokenTypeAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class HebrewTokenTypeAttributeImpl
extends AttributeImpl
implements HebrewTokenTypeAttribute {
    private HebrewTokenTypeAttribute.HebrewType type = HebrewTokenTypeAttribute.HebrewType.Unknown;
    private boolean isExact = false;

    @Override
    public void setType(HebrewTokenTypeAttribute.HebrewType type) {
        this.type = type;
    }

    @Override
    public HebrewTokenTypeAttribute.HebrewType getType() {
        return this.type;
    }

    @Override
    public boolean isHebrew() {
        return this.type == HebrewTokenTypeAttribute.HebrewType.Hebrew || this.type == HebrewTokenTypeAttribute.HebrewType.Acronym || this.type == HebrewTokenTypeAttribute.HebrewType.Construct;
    }

    @Override
    public boolean isNumeric() {
        return this.type == HebrewTokenTypeAttribute.HebrewType.Numeric;
    }

    @Override
    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public void setExact(boolean isExact) {
        this.isExact = isExact;
    }

    public void clear() {
        this.type = HebrewTokenTypeAttribute.HebrewType.Unknown;
        this.isExact = false;
    }

    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(KeywordAttribute.class, "isExact", (Object)this.isExact);
        reflector.reflect(KeywordAttribute.class, "type", (Object)this.type);
    }

    public void copyTo(AttributeImpl target) {
        ((HebrewTokenTypeAttribute)target).setType(this.type);
    }
}

