/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew.TokenFilters;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hebrew.HebrewTokenTypeAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class NiqqudFilter
extends TokenFilter {
    private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private HebrewTokenTypeAttribute hebTypeAtt = (HebrewTokenTypeAttribute)this.addAttribute(HebrewTokenTypeAttribute.class);

    public NiqqudFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (!this.hebTypeAtt.isHebrew()) {
            return true;
        }
        char[] buffer = this.termAtt.buffer();
        int length = this.termAtt.length();
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (buffer[i] >= '\u05af' && buffer[i] <= '\u05c4') continue;
            buffer[j++] = buffer[i];
        }
        this.termAtt.setLength(j);
        return true;
    }
}

