/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph;

import com.code972.hebmorph.DescFlag;
import com.code972.hebmorph.MorphData;
import com.code972.hebmorph.PrefixType;
import com.code972.hebmorph.Token;

public class HebrewToken
extends Token
implements Comparable<Token> {
    private static final long serialVersionUID = -5809495040446607703L;
    private float score = 1.0f;
    private byte prefixLength;
    private DescFlag mask;
    private String lemma;
    private PrefixType prefType;

    public HebrewToken(String _word, byte _prefixLength, MorphData.Lemma lemma, float _score) {
        this(_word, _prefixLength, lemma.getDescFlag(), lemma.getLemma(), lemma.getPrefix(), _score);
    }

    public HebrewToken(String _word, byte _prefixLength, DescFlag _mask, String _lemma, PrefixType _pref, float _score) {
        super(_word);
        this.prefixLength = _prefixLength;
        this.prefType = _pref;
        this.setMask(_mask);
        this.lemma = _lemma;
        this.setScore(_score);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HebrewToken)) {
            return false;
        }
        HebrewToken other = (HebrewToken)obj;
        if (this.lemma == null ? other.lemma != null : !this.lemma.equals(other.lemma)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals((Object)other.mask)) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        if (this.prefType == null ? other.prefType != null : !this.prefType.equals((Object)other.prefType)) {
            return false;
        }
        return Float.floatToIntBits(this.score) == Float.floatToIntBits(other.score);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.lemma == null ? 0 : this.lemma.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * result + this.prefixLength;
        result = 31 * result + Float.floatToIntBits(this.score);
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s", this.lemma);
    }

    @Override
    public final int compareTo(Token token) {
        HebrewToken other = (HebrewToken)(token instanceof HebrewToken ? token : null);
        if (other == null) {
            return -1;
        }
        return Float.valueOf(this.getScore()).compareTo(Float.valueOf(other.getScore()));
    }

    public void setScore(float score) {
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    public void setMask(DescFlag mask) {
        this.mask = mask;
    }

    public DescFlag getMask() {
        return this.mask;
    }

    public byte getPrefixLength() {
        return this.prefixLength;
    }

    public String getLemma() {
        return this.lemma;
    }
}

