/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph;

public class HebrewUtils {
    public static final char[] Geresh = new char[]{'\'', '\u05f3', '\u2018', '\u2019', '\u201b', '\uff07'};
    public static final char[] Gershayim = new char[]{'\"', '\u05f4', '\u201c', '\u201d', '\u201f', '\u275e', '\uff02'};
    public static final char[] Makaf = new char[]{'-', '\u2012', '\u2013', '\u2014', '\u2015', '\u05be'};
    public static final char[] CharsFollowingPrefixes = HebrewUtils.concatenateCharArrays(Geresh, Gershayim, Makaf);
    public static final char[] LettersAcceptingGeresh = new char[]{'\u05d6', '\u05d2', '\u05e5', '\u05e6', '\u05d7'};

    public static boolean isOfChars(char c, char[] options) {
        for (char o : options) {
            if (c != o) continue;
            return true;
        }
        return false;
    }

    public static char[] concatenateCharArrays(char[] ... arrays) {
        int count = 0;
        for (char[] a : arrays) {
            count += a.length;
        }
        char[] ret = new char[count];
        int offs = 0;
        for (char[] a : arrays) {
            System.arraycopy(a, 0, ret, offs, a.length);
            offs += a.length;
        }
        return ret;
    }

    public static boolean isHebrewLetter(char c) {
        return c >= '\u05d0' && c <= '\u05ea';
    }

    public static boolean isFinalHebrewLetter(char c) {
        return c == '\u05e3' || c == '\u05da' || c == '\u05dd' || c == '\u05e5' || c == '\u05df';
    }

    public static boolean isNiqqudChar(char c) {
        return c >= '\u05b0' && c <= '\u05b9' || c == '\u05c1' || c == '\u05c2' || c == '\u05bb' || c == '\u05bc';
    }
}

