/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph;

import com.code972.hebmorph.HebrewCharacters;
import com.code972.hebmorph.Reference;

public final class LookupTolerators {
    public static final ToleranceFunction[] TolerateEmKryiaAll = new ToleranceFunction[]{new TolerateEmKryiaYud(), new TolerateEmKryiaVav(), new TolerateNonDoubledConsonantVav()};

    public static class TolerateNonDoubledConsonantVav
    implements ToleranceFunction {
        @Override
        public Integer tolerate(char[] key, Reference<Byte> keyPos, String word, Reference<Float> score, char curChar) {
            if (curChar == HebrewCharacters.VAV || (Byte)keyPos.ref == 0 || (Byte)keyPos.ref + 1 == key.length) {
                return null;
            }
            if (key[(Byte)keyPos.ref] == HebrewCharacters.VAV && word.charAt(word.length() - 1) == HebrewCharacters.VAV) {
                Reference<Number> reference = keyPos;
                Byte by = (Byte)reference.ref;
                reference.ref = (byte)((Byte)reference.ref + 1);
                Byte by2 = reference.ref;
                reference = score;
                reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.8f);
                return 0;
            }
            return null;
        }
    }

    public static class TolerateEmKryiaVav
    implements ToleranceFunction {
        @Override
        public Integer tolerate(char[] key, Reference<Byte> keyPos, String word, Reference<Float> score, char curChar) {
            if (curChar != HebrewCharacters.VAV || (Byte)keyPos.ref == 0 || (Byte)keyPos.ref + 1 == key.length || key[(Byte)keyPos.ref] == HebrewCharacters.YOD || key[(Byte)keyPos.ref] == HebrewCharacters.HE || key[(Byte)keyPos.ref] == HebrewCharacters.VAV) {
                return null;
            }
            char prevChar = word.charAt(word.length() - 1);
            if (key[(Byte)keyPos.ref + 1] != HebrewCharacters.VAV && prevChar != HebrewCharacters.VAV && prevChar != HebrewCharacters.YOD) {
                Reference<Float> reference = score;
                reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.8f);
                return 1;
            }
            return null;
        }
    }

    public static class TolerateEmKryiaYud
    implements ToleranceFunction {
        @Override
        public Integer tolerate(char[] key, Reference<Byte> keyPos, String word, Reference<Float> score, char curChar) {
            if ((Byte)keyPos.ref == 0) {
                return null;
            }
            if (key[(Byte)keyPos.ref] == HebrewCharacters.VAV) {
                return null;
            }
            if (curChar != HebrewCharacters.YOD) {
                if (key[(Byte)keyPos.ref] == HebrewCharacters.YOD && key[(Byte)keyPos.ref - 1] == HebrewCharacters.YOD) {
                    Reference<Number> reference = score;
                    reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.9f);
                    reference = keyPos;
                    Byte by = (Byte)reference.ref;
                    reference.ref = (byte)((Byte)reference.ref + 1);
                    Byte by2 = reference.ref;
                    return 0;
                }
                if (key[(Byte)keyPos.ref] == HebrewCharacters.YOD) {
                    Reference<Number> reference = score;
                    reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.6f);
                    reference = keyPos;
                    Byte by = (Byte)reference.ref;
                    reference.ref = (byte)((Byte)reference.ref + 1);
                    Byte by3 = reference.ref;
                    return 0;
                }
                return null;
            }
            if (key[(Byte)keyPos.ref] == HebrewCharacters.YOD) {
                return null;
            }
            if (word.charAt(word.length() - 1) == HebrewCharacters.YOD) {
                if (key[(Byte)keyPos.ref - 1] != HebrewCharacters.YOD || (Byte)keyPos.ref + 1 == key.length && key.length <= 3) {
                    return null;
                }
                Reference<Float> reference = score;
                reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.8f);
                return 1;
            }
            if (word.charAt(word.length() - 1) != HebrewCharacters.VAV) {
                Reference<Float> reference = score;
                reference.ref = Float.valueOf(((Float)reference.ref).floatValue() * 0.8f);
                return 1;
            }
            return null;
        }
    }

    public static interface ToleranceFunction {
        public Integer tolerate(char[] var1, Reference<Byte> var2, String var3, Reference<Float> var4, char var5);
    }
}

