/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph;

import com.code972.hebmorph.DescFlag;
import com.code972.hebmorph.PrefixType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class MorphData {
    private ArrayList<Lemma> lemmas;
    private short prefixes;
    private boolean haltIfFound;

    public void setLemmas(Lemma[] lemmas) {
        Arrays.sort(lemmas, new Comparator<Lemma>(){

            @Override
            public int compare(Lemma l1, Lemma l2) {
                return l1.descFlag.getVal() - l2.descFlag.getVal();
            }
        });
        this.lemmas = new ArrayList<Lemma>(Arrays.asList(lemmas));
    }

    public Lemma[] getLemmas() {
        return this.lemmas.toArray(new Lemma[this.lemmas.size()]);
    }

    public void addLemma(Lemma lemma) {
        this.lemmas.add(lemma);
        Collections.sort(this.lemmas, new Comparator<Lemma>(){

            @Override
            public int compare(Lemma l1, Lemma l2) {
                return l1.descFlag.getVal() - l2.descFlag.getVal();
            }
        });
    }

    public void clearLemmas() {
        this.lemmas.clear();
    }

    public void setPrefixes(short prefixes) {
        this.prefixes = prefixes;
    }

    public int getPrefixes() {
        return this.prefixes;
    }

    public boolean haltIfFound() {
        return this.haltIfFound;
    }

    public void setHaltIfFound(boolean haltIfFound) {
        this.haltIfFound = haltIfFound;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MorphData other = (MorphData)obj;
        if (this.lemmas == null) {
            return other.lemmas == null;
        }
        return other.lemmas != null && this.lemmas.equals(other.lemmas);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lemmas.hashCode();
        return result;
    }

    public String toString() {
        return "{ prefix=" + this.prefixes + " lemmas=" + Arrays.asList(this.lemmas) + "}";
    }

    public static class Lemma {
        private final DescFlag descFlag;
        private final String lemma;
        private final PrefixType prefix;

        public Lemma(String lemma, DescFlag descFlag, PrefixType prefix) {
            this.lemma = lemma;
            this.descFlag = descFlag;
            this.prefix = prefix;
        }

        public DescFlag getDescFlag() {
            return this.descFlag;
        }

        public String getLemma() {
            return this.lemma;
        }

        public PrefixType getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Lemma other = (Lemma)obj;
            if (this.descFlag != other.descFlag) {
                return false;
            }
            if (this.prefix != other.prefix) {
                return false;
            }
            if (this.lemma == null) {
                return other.lemma == null;
            }
            return this.lemma.equals(other.lemma);
        }

        public int hashCode() {
            int prime = 37;
            int result = 1;
            result = 37 * result + this.descFlag.hashCode();
            result = 37 * result + this.prefix.getValue();
            result = 37 * result + (this.lemma == null ? 0 : this.lemma.hashCode());
            return result;
        }

        public String toString() {
            return this.lemma + ":" + (Object)((Object)this.descFlag) + ":" + (Object)((Object)this.prefix);
        }
    }
}

