/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph.datastructures;

import com.code972.hebmorph.LookupTolerators;
import com.code972.hebmorph.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DictRadix<T>
implements Iterable<T> {
    protected final DictNode m_root = new DictNode();
    protected int m_nCount = 0;
    private boolean m_bAllowValueOverride = false;
    private final boolean caseSensitiveKeys;

    public DictNode getRootNode() {
        return this.m_root;
    }

    public int getCount() {
        return this.m_nCount;
    }

    public boolean getAllowValueOverride() {
        return this.m_bAllowValueOverride;
    }

    public void setAllowValueOverride(boolean val) {
        this.m_bAllowValueOverride = val;
    }

    public DictRadix() {
        this(true);
    }

    public DictRadix(boolean caseSensitiveKeys) {
        this.caseSensitiveKeys = caseSensitiveKeys;
    }

    public T lookup(String key) {
        return this.lookup(key.toCharArray(), false);
    }

    public T lookup(String key, boolean allowPartial) {
        return this.lookup(key.toCharArray(), allowPartial);
    }

    public T lookup(char[] key, boolean allowPartial) throws IllegalArgumentException {
        return this.lookup(key, 0, DictRadix.getCharArrayLength(key), allowPartial);
    }

    public T lookup(char[] key, int keyPos, int keyLength, boolean allowPartial) throws IllegalArgumentException {
        return this.lookup(key, keyPos, keyLength, 0, allowPartial);
    }

    public T lookup(char[] key, int keyPos, int keyLength, int keyOffset, boolean allowPartial) throws IllegalArgumentException {
        DictNode dn = this.lookupImpl(key, keyPos, keyLength, keyOffset, allowPartial);
        if (dn == null) {
            return null;
        }
        return dn.getValue();
    }

    private DictNode lookupImpl(char[] key, int keyPos, int keyLength, int keyOffset, boolean allowPartial) {
        DictNode cur = this.m_root;
        block0: while (cur != null && cur.getChildren() != null) {
            int childPos = 0;
            while (true) {
                int n;
                DictNode child = cur.getChildren()[childPos];
                char[] childKey = child.getKey();
                for (n = 0; n < childKey.length && keyPos - keyOffset < keyLength && (childKey[n] == key[keyPos] || !this.caseSensitiveKeys && childKey[n] == Character.toLowerCase(key[keyPos])); ++n) {
                    ++keyPos;
                }
                if (n == childKey.length) {
                    if (keyLength == keyPos - keyOffset) {
                        return child;
                    }
                    if (keyLength > keyPos - keyOffset) {
                        cur = child;
                        continue block0;
                    }
                } else {
                    if (allowPartial && keyPos - keyOffset == keyLength) {
                        return null;
                    }
                    if (n > 0 || childPos + 1 == cur.getChildren().length) {
                        throw new IllegalArgumentException();
                    }
                }
                ++childPos;
            }
        }
        if (allowPartial && keyLength == keyPos - keyOffset) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    public List<LookupResult> lookupTolerant(String strKey, LookupTolerators.ToleranceFunction[] tolFuncs) {
        TolerantLookupCrawler tlc = new TolerantLookupCrawler(tolFuncs);
        return tlc.lookupTolerant(strKey);
    }

    private static int getCharArrayLength(char[] ar) {
        int i;
        for (i = 0; ar.length > i && ar[i] != '\u0000'; ++i) {
        }
        return i;
    }

    public void addNode(String key, T data) {
        this.addNode(key.toCharArray(), data);
    }

    public void addNode(char[] key, T data) {
        if (!this.caseSensitiveKeys) {
            for (int i = 0; i < key.length; ++i) {
                key[i] = Character.toLowerCase(key[i]);
            }
        }
        int keyLength = DictRadix.getCharArrayLength(key);
        int keyPos = 0;
        DictNode cur = this.m_root;
        while (cur != null) {
            int curPos;
            if (cur.getChildren() == null) {
                DictNode newChild = new DictNode();
                newChild.setKey(new char[keyLength - keyPos]);
                System.arraycopy(key, keyPos, newChild.getKey(), 0, newChild.getKey().length);
                newChild.setValue(data);
                cur.setChildren((DictNode[])Array.newInstance(DictNode.class, 1));
                cur.getChildren()[0] = newChild;
                ++this.m_nCount;
                return;
            }
            boolean bFoundChild = false;
            for (int childPos = 0; childPos < cur.getChildren().length; ++childPos) {
                int n;
                DictNode child = cur.getChildren()[childPos];
                for (n = 0; n < child.getKey().length && keyPos < keyLength && child.getKey()[n] == key[keyPos] && key[keyPos] != '\u0000'; ++keyPos, ++n) {
                }
                if (n <= 0) continue;
                bFoundChild = true;
                if (n == child.getKey().length && keyLength > keyPos) {
                    cur = child;
                    break;
                }
                if (child.getKey().length > n && keyLength > keyPos) {
                    DictNode bridgeChild = new DictNode();
                    bridgeChild.setKey(new char[n]);
                    System.arraycopy(child.getKey(), 0, bridgeChild.getKey(), 0, n);
                    int childNewKeyLen = child.getKey().length - n;
                    char[] childNewKey = new char[childNewKeyLen];
                    System.arraycopy(child.getKey(), n, childNewKey, 0, childNewKeyLen);
                    child.setKey(childNewKey);
                    bridgeChild.setChildren((DictNode[])Array.newInstance(DictNode.class, 2));
                    DictNode newNode = new DictNode();
                    newNode.setKey(new char[keyLength - keyPos]);
                    System.arraycopy(key, keyPos, newNode.getKey(), 0, newNode.getKey().length);
                    newNode.setValue(data);
                    if (child.getKey()[0] - newNode.getKey()[0] < 0) {
                        bridgeChild.getChildren()[0] = child;
                        bridgeChild.getChildren()[1] = newNode;
                    } else {
                        bridgeChild.getChildren()[0] = newNode;
                        bridgeChild.getChildren()[1] = child;
                    }
                    cur.getChildren()[childPos] = bridgeChild;
                    ++this.m_nCount;
                    return;
                }
                if (child.getKey().length > n && keyLength == keyPos) {
                    DictNode newChild = new DictNode();
                    newChild.setKey(new char[n]);
                    System.arraycopy(child.getKey(), 0, newChild.getKey(), 0, n);
                    int childNewKeyLen = child.getKey().length - n;
                    char[] childNewKey = new char[childNewKeyLen];
                    System.arraycopy(child.getKey(), n, childNewKey, 0, childNewKeyLen);
                    child.setKey(childNewKey);
                    newChild.setChildren((DictNode[])Array.newInstance(DictNode.class, 1));
                    newChild.getChildren()[0] = child;
                    newChild.setValue(data);
                    cur.getChildren()[childPos] = newChild;
                    ++this.m_nCount;
                    return;
                }
                if (n != child.getKey().length || keyLength != keyPos) continue;
                if (child.getValue() == null) {
                    child.setValue(data);
                    ++this.m_nCount;
                } else if (this.m_bAllowValueOverride) {
                    child.value = data;
                }
                return;
            }
            if (bFoundChild) continue;
            DictNode newChild = new DictNode();
            newChild.setKey(new char[keyLength - keyPos]);
            System.arraycopy(key, keyPos, newChild.getKey(), 0, newChild.getKey().length);
            newChild.setValue(data);
            DictNode[] newArray = (DictNode[])Array.newInstance(DictNode.class, cur.getChildren().length + 1);
            for (curPos = 0; curPos < cur.getChildren().length && newChild.getKey()[0] - cur.getChildren()[curPos].getKey()[0] >= 0; ++curPos) {
                newArray[curPos] = cur.getChildren()[curPos];
            }
            newArray[curPos] = newChild;
            while (curPos < cur.getChildren().length) {
                newArray[curPos + 1] = cur.getChildren()[curPos];
                ++curPos;
            }
            cur.setChildren(newArray);
            ++this.m_nCount;
            return;
        }
    }

    public void clear() {
        this.m_root.clear();
        this.m_nCount = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new RadixEnumerator(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DictRadix dict2 = (DictRadix)other;
        if (this.getCount() != dict2.getCount()) {
            return false;
        }
        RadixEnumerator en1 = (RadixEnumerator)this.iterator();
        RadixEnumerator en2 = (RadixEnumerator)dict2.iterator();
        while (en1.hasNext() && en2.hasNext()) {
            if (!en1.getCurrentKey().equals(en2.getCurrentKey())) {
                return false;
            }
            if (en1.next().equals(en2.next())) continue;
            return false;
        }
        return (!en1.hasNext() || en2.hasNext()) && (en1.hasNext() || !en2.hasNext());
    }

    public class RadixEnumerator
    implements Iterator<T> {
        private DictRadix<T> radix;
        private LinkedList<DictNode> nodesPath;

        public RadixEnumerator(DictRadix<T> r) {
            this.radix = r;
            this.nodesPath = new LinkedList();
            this.nodesPath.addLast(this.radix.m_root);
        }

        public String getCurrentKey() {
            StringBuilder sb = new StringBuilder();
            for (DictNode dn : this.nodesPath) {
                if (dn.key != null) {
                    sb.append(dn.key);
                    continue;
                }
                assert (dn == this.radix.m_root);
            }
            return sb.toString();
        }

        @Override
        public T next() {
            assert (this.nodesPath.size() > 0);
            return this.nodesPath.getLast().getValue();
        }

        @Override
        public boolean hasNext() {
            boolean goUp = false;
            block0: while (this.nodesPath.size() > 0) {
                DictNode n = this.nodesPath.getLast();
                if (goUp || n.getChildren() == null || n.getChildren().length == 0) {
                    this.nodesPath.removeLast();
                    if (this.nodesPath.isEmpty()) break;
                    goUp = true;
                    for (int i = 0; i < this.nodesPath.getLast().getChildren().length; ++i) {
                        if (this.nodesPath.getLast().getChildren()[i] != n || i + 1 >= this.nodesPath.getLast().getChildren().length) continue;
                        this.nodesPath.addLast(this.nodesPath.getLast().getChildren()[i + 1]);
                        if (this.nodesPath.getLast().getValue() != null) {
                            return true;
                        }
                        goUp = false;
                        continue block0;
                    }
                    continue;
                }
                this.nodesPath.addLast(n.getChildren()[0]);
                goUp = false;
                if (n.getChildren()[0].getValue() == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int prime = 31;
            int ret = DictRadix.this.m_root.getKey().hashCode();
            ret = 31 * ret + DictRadix.this.m_root.getChildren().length;
            ret = 31 * ret + DictRadix.this.m_root.getValue().hashCode();
            return 31 * ret + DictRadix.this.m_nCount;
        }
    }

    public class LookupResult {
        private String word;
        private T data;
        private float score;

        public void setScore(float score) {
            this.score = score;
        }

        public float getScore() {
            return this.score;
        }

        public void setData(T data) {
            this.data = data;
        }

        public T getData() {
            return this.data;
        }

        public void setWord(String word) {
            this.word = word;
        }

        public String getWord() {
            return this.word;
        }

        public LookupResult(String _word, T _data, float _score) {
            this.setWord(_word);
            this.setData(_data);
            this.setScore(_score);
        }
    }

    protected class TolerantLookupCrawler {
        private LookupTolerators.ToleranceFunction[] toleranceFunctions;
        private char[] key;

        public TolerantLookupCrawler(LookupTolerators.ToleranceFunction[] _tolFuncs) {
            this.toleranceFunctions = _tolFuncs;
        }

        public List<LookupResult> lookupTolerant(String strKey) {
            ArrayList<LookupResult> resultSet = new ArrayList<LookupResult>();
            this.key = strKey.toCharArray();
            this.lookupTolerantImpl(DictRadix.this.getRootNode(), new MatchCandidate(0, "", 1.0f), resultSet);
            if (resultSet.size() > 0) {
                return resultSet;
            }
            return null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void lookupTolerantImpl(DictNode cur, MatchCandidate mc, List resultSet) {
            if (cur.getChildren() == null) {
                return;
            }
            for (int childPos = 0; childPos < cur.getChildren().length; ++childPos) {
                DictNode child = cur.getChildren()[childPos];
                this.doKeyMatching(child, (byte)0, mc, resultSet);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void doKeyMatching(DictNode node, byte nodeKeyPos, MatchCandidate mc, List resultSet) {
            byte currentKeyPos;
            byte startingNodeKeyPos = nodeKeyPos;
            for (currentKeyPos = mc.keyPos; nodeKeyPos < node.getKey().length && currentKeyPos < this.key.length; currentKeyPos = (byte)(currentKeyPos + 1), nodeKeyPos = (byte)(nodeKeyPos + 1)) {
                for (LookupTolerators.ToleranceFunction tf : this.toleranceFunctions) {
                    byte tmpKeyPos = mc.keyPos;
                    float tmpScore = mc.getScore();
                    Reference<Byte> tempRefObject = new Reference<Byte>(tmpKeyPos);
                    Reference<Float> tempRefObject2 = new Reference<Float>(Float.valueOf(tmpScore));
                    Integer tret = tf.tolerate(this.key, tempRefObject, mc.getWord(), tempRefObject2, node.getKey()[nodeKeyPos]);
                    tmpKeyPos = (Byte)tempRefObject.ref;
                    tmpScore = ((Float)tempRefObject2.ref).floatValue();
                    if (tret == null) continue;
                    String consumedLetters = "";
                    if (tret > 0 && tret <= node.getKey().length) {
                        consumedLetters = new String(node.getKey(), (int)nodeKeyPos, (int)tret);
                    }
                    MatchCandidate nmc = new MatchCandidate(tmpKeyPos, mc.getWord() + consumedLetters, tmpScore);
                    if (nodeKeyPos + tret == node.getKey().length) {
                        this.lookupTolerantImpl(node, nmc, resultSet);
                        continue;
                    }
                    this.doKeyMatching(node, (byte)(nodeKeyPos + tret), nmc, resultSet);
                }
                if (node.getKey()[nodeKeyPos] != this.key[currentKeyPos]) break;
            }
            if (nodeKeyPos == node.getKey().length) {
                if (currentKeyPos == this.key.length) {
                    if (node.getValue() != null) {
                        resultSet.add(new LookupResult(mc.getWord() + new String(node.getKey(), (int)startingNodeKeyPos, nodeKeyPos - startingNodeKeyPos), node.getValue(), mc.getScore()));
                    }
                } else {
                    MatchCandidate nmc = new MatchCandidate(currentKeyPos, mc.getWord() + new String(node.getKey(), (int)startingNodeKeyPos, nodeKeyPos - startingNodeKeyPos), mc.getScore());
                    this.lookupTolerantImpl(node, nmc, resultSet);
                }
            }
        }

        protected class MatchCandidate {
            private byte keyPos;
            private String word;
            private float score = 1.0f;

            public MatchCandidate(byte _keyPos, String _word, float _score) {
                this.keyPos = _keyPos;
                this.word = _word;
                this.score = _score;
            }

            public byte getKeyPos() {
                return this.keyPos;
            }

            public void setKeyPos(byte keyPos) {
                this.keyPos = keyPos;
            }

            public String getWord() {
                return this.word;
            }

            public void setWord(String word) {
                this.word = word;
            }

            public float getScore() {
                return this.score;
            }

            public void setScore(float score) {
                this.score = score;
            }
        }
    }

    public class DictNode {
        private DictNode[] children;
        private char[] key;
        private T value;

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setChildren(DictNode[] children) {
            this.children = children;
        }

        public DictNode[] getChildren() {
            return this.children;
        }

        public void setKey(char[] key) {
            this.key = key;
        }

        public final char[] getKey() {
            return this.key;
        }

        public void clear() {
            this.children = null;
            this.key = null;
            this.value = null;
        }

        public String toString() {
            return "[ value=" + this.value + "; children=" + this.children.length + " ]";
        }
    }
}

