/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph.hspell;

import com.code972.hebmorph.DictionaryLoader;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.hspell.HSpellLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashSet;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class HSpellDictionaryLoader
implements DictionaryLoader {
    @Override
    public String dictionaryLoaderName() {
        return "hspell";
    }

    @Override
    @Deprecated
    public String[] dictionaryPossiblePaths() {
        return this.getPossiblePaths(new String[0]);
    }

    @Override
    public String[] getPossiblePaths(String ... basePaths) {
        HashSet<String> paths = new HashSet<String>();
        if (basePaths != null) {
            for (String basePath : basePaths) {
                paths.add(Paths.get(basePath, "hspell-data-files").toAbsolutePath().toString());
            }
        }
        paths.add("/var/lib/hspell-data-files/");
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public DictHebMorph loadDictionary(InputStream stream) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public DictHebMorph loadDictionaryFromPath(String path) throws IOException {
        File file;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((file = new File(path)).isDirectory()) {
            HSpellLoader loader = new HSpellLoader(new File(path), true);
            return loader.loadDictionaryFromHSpellData(new FileInputStream(new File(path, "prefix_h.gz")));
        }
        throw new IOException("Expected a folder. Cannot load dictionary from HSpell files.");
    }

    @Override
    public DictHebMorph loadDictionaryFromDefaultPath() throws IOException {
        HSpellLoader loader = new HSpellLoader(new File(HSpellLoader.getHspellPath()), true);
        return loader.loadDictionaryFromHSpellData(new FileInputStream(new File(HSpellLoader.getHspellPath(), "prefix_noH.gz")));
    }
}

