/*
 * Decompiled with CFR 0.152.
 */
package com.code972.hebmorph.hspell;

import com.code972.hebmorph.DescFlag;
import com.code972.hebmorph.DictionaryLoader;
import com.code972.hebmorph.MorphData;
import com.code972.hebmorph.PrefixType;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.datastructures.DictRadix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

final class HSpellLoader {
    public static final String DELIMETER = "#";
    public static final String PREFIXES_INDICATOR = "#PREFIXES";
    public static final String DICTIONARY_INDICATOR = "#DICTIONARY";
    public static final String dictionaryFile = "hebrew.wgz";
    public static final String prefixesFile = "hebrew.wgz.prefixes";
    public static final String stemsFile = "hebrew.wgz.stems";
    public static final String descFile = "hebrew.wgz.desc";
    public static final String sizesFile = "hebrew.wgz.sizes";
    public static final String dmaskFile = "dmask.c";
    public static final String PREFIX_H = "prefix_h.gz";
    public static final String PREFIX_NOH = "prefix_noH.gz";
    protected List<Integer> dmasks;
    protected final boolean loadMorphData;
    private int lookupLen;
    protected InputStream fdict;
    protected InputStream fprefixes;
    protected InputStream fdesc = null;
    protected InputStream fstem = null;
    private int bufPos = 0;
    private final int[] buf = new int[5];
    private final ArrayList<Integer> wordMasks = new ArrayList();
    private final ArrayList<Integer> wordStems = new ArrayList();
    private static final int descFlags_noun = 69;
    private static final int descFlags_person_name = 262145;
    private static final int descFlags_place_name = 262153;
    private static final int descFlags_empty = 0;

    public HSpellLoader(File hspellFolder, boolean loadMorphData) throws IOException {
        this(new FileInputStream(new File(hspellFolder, sizesFile)), new FileInputStream(new File(hspellFolder, dmaskFile)), new FileInputStream(new File(hspellFolder, dictionaryFile)), new FileInputStream(new File(hspellFolder, prefixesFile)), new FileInputStream(new File(hspellFolder, descFile)), new FileInputStream(new File(hspellFolder, stemsFile)), loadMorphData);
        if (!hspellFolder.exists() || !hspellFolder.isDirectory()) {
            throw new IllegalArgumentException("Invalid hspell data folder provided");
        }
    }

    public HSpellLoader(ClassLoader classloader, String hspellFolder, boolean loadMorphData) throws IOException {
        this(classloader.getResourceAsStream(hspellFolder + sizesFile), classloader.getResourceAsStream(hspellFolder + dmaskFile), classloader.getResourceAsStream(hspellFolder + dictionaryFile), classloader.getResourceAsStream(hspellFolder + prefixesFile), classloader.getResourceAsStream(hspellFolder + descFile), classloader.getResourceAsStream(hspellFolder + stemsFile), loadMorphData);
    }

    public HSpellLoader(InputStream sizesFile, InputStream dmasksFile, InputStream dictFile, InputStream prefixesFile, InputStream descFile, InputStream stemsFile, boolean loadMorphData) throws IOException {
        this.fdict = new GZIPInputStream(dictFile);
        this.fprefixes = new GZIPInputStream(prefixesFile);
        this.loadMorphData = loadMorphData;
        if (loadMorphData) {
            String line;
            this.dmasks = new ArrayList<Integer>();
            boolean foundStartLine = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(dmasksFile));
            while ((line = reader.readLine()) != null) {
                if (!foundStartLine) {
                    if (!line.contains("dmasks[]")) continue;
                    foundStartLine = true;
                    continue;
                }
                int i = HSpellLoader.tryParseInt(line);
                if (i < 0) continue;
                this.dmasks.add(i);
            }
            reader.close();
            this.lookupLen = HSpellLoader.getWordCountInHSpellFolder(sizesFile);
            this.fdesc = new GZIPInputStream(descFile);
            this.fstem = new GZIPInputStream(stemsFile);
        }
    }

    public static String getHspellPath() {
        String hspellPath = null;
        ClassLoader classLoader = HSpellLoader.class.getClassLoader();
        File folder = new File(classLoader.getResource("").getPath());
        do {
            File tmp;
            if (!(tmp = new File(folder, "hspell-data-files")).exists() || !tmp.isDirectory()) continue;
            hspellPath = tmp.toString();
            break;
        } while ((folder = folder.getParentFile()) != null);
        if (hspellPath == null) {
            throw new IllegalArgumentException("path to hspell data folder couldn't be found");
        }
        if (!hspellPath.endsWith("/")) {
            hspellPath = hspellPath + "/";
        }
        return hspellPath;
    }

    public static HashMap<String, Integer> readDefaultPrefixes() throws IOException {
        return HSpellLoader.readPrefixesFromFile(new FileInputStream(new File(HSpellLoader.getHspellPath(), PREFIX_NOH)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Integer> readPrefixesFromFile(InputStream inputStream) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        GZIPInputStream reader = null;
        BufferedReader bufferedReader = null;
        try {
            String str;
            reader = new GZIPInputStream(inputStream);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)reader, DictionaryLoader.ENCODING_USED));
            while ((str = bufferedReader.readLine()) != null) {
                String[] split = str.split(DELIMETER);
                if (split.length != 2) {
                    throw new IOException("Wrong format detected\n");
                }
                map.put(split[0], Integer.parseInt(split[1]));
            }
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e);
            HashMap<String, Integer> hashMap = null;
            return hashMap;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DictHebMorph loadDictionaryFromHSpellData(InputStream inputStream) throws IOException {
        DictHebMorph dict = new DictHebMorph();
        dict.setPref(HSpellLoader.readPrefixesFromFile(inputStream));
        if (this.loadMorphData) {
            String[] lookup = new String[this.lookupLen + 1];
            try {
                char[] sbuf = new char[127];
                int c = 0;
                int slen = 0;
                int i = 0;
                while ((c = this.fdict.read()) > -1) {
                    if (c >= 48 && c <= 57) {
                        lookup[i++] = new String(sbuf, 0, slen);
                        int n = 0;
                        do {
                            n *= 10;
                            n += c - 48;
                        } while ((c = this.fdict.read()) > -1 && c >= 48 && c <= 57);
                        slen -= n;
                    }
                    sbuf[slen++] = HSpellLoader.ISO8859_To_Unicode(c);
                }
            }
            finally {
                if (this.fdict != null) {
                    try {
                        this.fdict.close();
                    }
                    catch (IOException sbuf) {}
                }
            }
            try {
                int i = 0;
                while (lookup[i] != null) {
                    MorphData data = new MorphData();
                    data.setPrefixes((short)this.fprefixes.read());
                    Integer[] descFlags = this.readDescFile(this.fdesc);
                    List<Integer> stemReferences = this.readStemFile(this.fstem);
                    MorphData.Lemma[] lemmas = new MorphData.Lemma[stemReferences.size()];
                    int stemPosition = 0;
                    for (int r : stemReferences) {
                        String lemma = lookup[r].equals("\u05e9\u05d5\u05e0\u05d5\u05ea") && !lookup[r].equals(lookup[i]) ? null : lookup[r];
                        lemmas[stemPosition] = new MorphData.Lemma(lemma, DescFlag.create((byte)(descFlags[stemPosition] & 3)), HSpellLoader.dmaskToPrefix(descFlags[stemPosition]));
                        ++stemPosition;
                    }
                    data.setLemmas(lemmas);
                    dict.addNode(lookup[i], data);
                    ++i;
                }
            }
            finally {
                if (this.fprefixes != null) {
                    try {
                        this.fprefixes.close();
                    }
                    catch (IOException i) {}
                }
                if (this.fdesc != null) {
                    try {
                        this.fdesc.close();
                    }
                    catch (IOException i) {}
                }
                if (this.fstem != null) {
                    try {
                        this.fstem.close();
                    }
                    catch (IOException i) {}
                }
            }
        }
        try {
            char[] sbuf = new char[127];
            int c = 0;
            int slen = 0;
            while ((c = this.fdict.read()) > -1) {
                if (c >= 48 && c <= 57) {
                    sbuf[slen] = '\u0000';
                    MorphData data = new MorphData();
                    data.setPrefixes((short)this.fprefixes.read());
                    dict.addNode(sbuf, data);
                    int n = 0;
                    do {
                        n *= 10;
                        n += c - 48;
                    } while ((c = this.fdict.read()) > -1 && c >= 48 && c <= 57);
                    slen -= n;
                }
                sbuf[slen++] = HSpellLoader.ISO8859_To_Unicode(c);
            }
        }
        finally {
            if (this.fprefixes != null) {
                try {
                    this.fprefixes.close();
                }
                catch (IOException iOException) {}
            }
            if (this.fdict != null) {
                try {
                    this.fdict.close();
                }
                catch (IOException iOException) {}
            }
        }
        return dict;
    }

    public static int getWordCountInHSpellFolder(File path) throws IOException {
        return HSpellLoader.getWordCountInHSpellFolder(new FileInputStream(new File(path, sizesFile)));
    }

    public static int getWordCountInHSpellFolder(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        reader.readLine();
        String sizes = reader.readLine();
        reader.close();
        int tmp = sizes.indexOf(32, sizes.indexOf(10));
        tmp = Integer.parseInt(sizes.substring(tmp + 1).trim());
        return tmp - 1;
    }

    final Integer[] readDescFile(InputStream fdesc) throws IOException {
        while ((this.buf[this.bufPos] = fdesc.read()) > -1) {
            if (this.buf[this.bufPos] == 10 || this.buf[this.bufPos] == 0) {
                this.bufPos = 0;
                Integer[] ret = this.wordMasks.toArray(new Integer[this.wordMasks.size()]);
                this.wordMasks.clear();
                return ret;
            }
            ++this.bufPos;
            if (this.bufPos % 2 != 0) continue;
            int i = this.buf[0] - 65 + (this.buf[1] - 65) * 26;
            this.wordMasks.add(this.dmasks.get(i));
            this.bufPos = 0;
        }
        return null;
    }

    final List<Integer> readStemFile(InputStream fstem) throws IOException {
        this.wordStems.clear();
        while ((this.buf[this.bufPos] = fstem.read()) > -1) {
            if (this.buf[this.bufPos] == 10 || this.buf[this.bufPos] == 0) {
                this.bufPos = 0;
                return this.wordStems;
            }
            ++this.bufPos;
            if (this.bufPos % 3 != 0) continue;
            this.wordStems.add(this.buf[0] - 33 + (this.buf[1] - 33) * 94 + (this.buf[2] - 33) * 94 * 94);
            this.bufPos = 0;
        }
        return null;
    }

    private static char ISO8859_To_Unicode(int c) {
        if (c >= 224 && c <= 250) {
            return (char)(c + 1264);
        }
        if (c <= 190) {
            return (char)c;
        }
        return ' ';
    }

    public static DictRadix<MorphData> loadCustomWords(InputStream customWordsStream, DictRadix<MorphData> dictRadix) throws IOException {
        String line;
        if (customWordsStream == null) {
            return null;
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(customWordsStream, Charset.forName("UTF-8")));
        Hashtable<String, String> secondPass = new Hashtable<String, String>();
        DictRadix<MorphData> custom = new DictRadix<MorphData>();
        while ((line = input.readLine()) != null) {
            String[] cells = line.split(" ");
            if (cells.length < 2) continue;
            MorphData md = null;
            switch (cells[1]) {
                case "\u05e9\u05dd\u05e2\u05e6\u05dd": {
                    md = new MorphData();
                    md.setPrefixes((short)63);
                    md.setLemmas(new MorphData.Lemma[]{new MorphData.Lemma(cells[0], DescFlag.D_NOUN, HSpellLoader.dmaskToPrefix(69))});
                    break;
                }
                case "\u05e9\u05dd\u05d7\u05d1\u05e8\u05d4": 
                case "\u05e9\u05dd\u05e4\u05e8\u05d8\u05d9": {
                    md = new MorphData();
                    md.setPrefixes((short)8);
                    md.setLemmas(new MorphData.Lemma[]{new MorphData.Lemma(cells[0], DescFlag.D_PROPER, HSpellLoader.dmaskToPrefix(262145))});
                    break;
                }
                case "\u05e9\u05dd\u05de\u05e7\u05d5\u05dd": {
                    md = new MorphData();
                    md.setPrefixes((short)8);
                    md.setLemmas(new MorphData.Lemma[]{new MorphData.Lemma(cells[0], DescFlag.D_PROPER, HSpellLoader.dmaskToPrefix(262153))});
                    break;
                }
                case "\u05e9\u05dd\u05de\u05d3\u05d5\u05d9\u05e7": {
                    md = new MorphData();
                    md.setPrefixes((short)0);
                    md.setLemmas(new MorphData.Lemma[]{new MorphData.Lemma(cells[0], DescFlag.D_PROPER, HSpellLoader.dmaskToPrefix(0))});
                }
            }
            if (md == null) {
                try {
                    md = custom.lookup(cells[1], false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (md == null) {
                try {
                    md = dictRadix.lookup(cells[1], false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (md != null) {
                custom.addNode(cells[0], md);
                continue;
            }
            secondPass.put(cells[0], cells[1]);
        }
        for (Map.Entry entry : secondPass.entrySet()) {
            try {
                custom.lookup((String)entry.getKey(), false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    MorphData md = custom.lookup((String)entry.getValue(), false);
                    if (md == null) continue;
                    custom.addNode((String)entry.getKey(), md);
                }
                catch (IllegalArgumentException illegalArgumentException2) {}
            }
        }
        return custom;
    }

    public static int tryParseInt(String str) {
        if (str == null) {
            return -1;
        }
        int length = str.length();
        int n = length = str.endsWith(",") ? length - 1 : length;
        if (length == 0) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c <= '/' || c >= ':') {
                return -1;
            }
            int digit = c - 48;
            num *= 10;
            num += digit;
        }
        return num;
    }

    private static PrefixType dmaskToPrefix(Integer dmask) {
        PrefixType specifier;
        if ((dmask & 3) == 2) {
            specifier = (dmask & 0x700) == 1280 ? PrefixType.PS_IMPER : ((dmask & 0x700) != 768 ? PrefixType.PS_VERB : ((dmask & 0x20000) > 0 || (dmask & 0x1F800) > 0 ? PrefixType.PS_NONDEF : PrefixType.PS_ALL));
            if ((dmask & 0x700) == 256) {
                specifier = PrefixType.PS_L;
            } else if ((dmask & 0x700) == 1536) {
                specifier = PrefixType.PS_B;
            }
        } else {
            specifier = (dmask & 3) == 1 || (dmask & 3) == 3 ? ((dmask & 0x20000) > 0 || (dmask & 0x1F800) > 0 || (dmask & 0x40000) > 0 ? PrefixType.PS_NONDEF : PrefixType.PS_ALL) : PrefixType.PS_ALL;
        }
        return specifier;
    }

    private static interface DMask {
        public static final int D_NOUN = 1;
        public static final int D_VERB = 2;
        public static final int D_ADJ = 3;
        public static final int D_TYPEMASK = 3;
        public static final int D_GENDERBASE = 4;
        public static final int D_MASCULINE = 4;
        public static final int D_FEMININE = 8;
        public static final int D_GENDERMASK = 12;
        public static final int D_GUFBASE = 16;
        public static final int D_FIRST = 16;
        public static final int D_SECOND = 32;
        public static final int D_THIRD = 48;
        public static final int D_GUFMASK = 48;
        public static final int D_NUMBASE = 64;
        public static final int D_SINGULAR = 64;
        public static final int D_DOUBLE = 128;
        public static final int D_PLURAL = 192;
        public static final int D_NUMMASK = 192;
        public static final int D_TENSEBASE = 256;
        public static final int D_INFINITIVE = 256;
        public static final int D_BINFINITIVE = 1536;
        public static final int D_PAST = 512;
        public static final int D_PRESENT = 768;
        public static final int D_FUTURE = 1024;
        public static final int D_IMPERATIVE = 1280;
        public static final int D_TENSEMASK = 1792;
        public static final int D_OGENDERBASE = 2048;
        public static final int D_OMASCULINE = 2048;
        public static final int D_OFEMININE = 4096;
        public static final int D_OGENDERMASK = 6144;
        public static final int D_OGUFBASE = 8192;
        public static final int D_OFIRST = 8192;
        public static final int D_OSECOND = 16384;
        public static final int D_OTHIRD = 24576;
        public static final int D_OGUFMASK = 24576;
        public static final int D_ONUMBASE = 32768;
        public static final int D_OSINGULAR = 32768;
        public static final int D_ODOUBLE = 65536;
        public static final int D_OPLURAL = 98304;
        public static final int D_ONUMMASK = 98304;
        public static final int D_OMASK = 129024;
        public static final int D_OSMICHUT = 131072;
        public static final int D_SPECNOUN = 262144;
        public static final int D_STARTBIT = 524288;
        public static final int D_ACRONYM = 0x100000;
    }
}

