/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import com.code972.hebmorph.datastructures.DictHebMorph;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.hebrew.HebrewAnalyzer;
import org.apache.lucene.analysis.hebrew.HebrewTokenizer;
import org.apache.lucene.analysis.hebrew.TokenFilters.AddSuffixTokenFilter;
import org.apache.lucene.analysis.hebrew.TokenFilters.HebrewLemmatizerTokenFilter;
import org.apache.lucene.analysis.hebrew.TokenFilters.NiqqudFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;

public class HebrewQueryAnalyzer
extends HebrewAnalyzer {
    public HebrewQueryAnalyzer(DictHebMorph dict) throws IOException {
        super(dict);
    }

    public HebrewQueryAnalyzer() throws IOException {
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        HebrewTokenizer src = new HebrewTokenizer(this.dict.getPref(), this.SPECIAL_TOKENIZATION_CASES);
        src.setSuffixForExactMatch(Character.valueOf('$'));
        TokenFilter tok = new NiqqudFilter((TokenStream)src);
        tok = new ASCIIFoldingFilter((TokenStream)tok);
        tok = new LowerCaseFilter((TokenStream)tok);
        tok = new HebrewLemmatizerTokenFilter((TokenStream)tok, this.dict, false, true);
        tok = new AddSuffixTokenFilter((TokenStream)tok, Character.valueOf('$'));
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }
}

