/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import com.code972.hebmorph.Reference;
import com.code972.hebmorph.Tokenizer;
import com.code972.hebmorph.datastructures.DictRadix;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.hebrew.HebrewTokenTypeAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class HebrewTokenizer
extends Tokenizer {
    private final com.code972.hebmorph.Tokenizer hebMorphTokenizer;
    private final HashMap<String, Integer> prefixesTree;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final HebrewTokenTypeAttribute hebTypeAtt = (HebrewTokenTypeAttribute)this.addAttribute(HebrewTokenTypeAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    public static final String[] TOKEN_TYPE_SIGNATURES = new String[]{"<HEBREW>", "<NON_HEBREW>", "<NUM>", "<CONSTRUCT>", "<ACRONYM>", "<MIXED>", null};

    public HebrewTokenizer(HashMap<String, Integer> prefixes) {
        this(prefixes, null);
    }

    public HebrewTokenizer(HashMap<String, Integer> _prefixesTree, DictRadix<Byte> specialCases) {
        this.hebMorphTokenizer = new com.code972.hebmorph.Tokenizer(this.input, _prefixesTree, specialCases);
        this.prefixesTree = _prefixesTree;
    }

    public void setSuffixForExactMatch(Character suffixForExactMatch) {
        this.hebMorphTokenizer.setSuffixForExactMatch(suffixForExactMatch);
    }

    public static String tokenTypeSignature(int tokenType) {
        return TOKEN_TYPE_SIGNATURES[tokenType];
    }

    public boolean incrementToken() throws IOException {
        int tokenType;
        String nextTokenVal;
        block12: {
            this.clearAttributes();
            Reference<Object> nextToken = new Reference<Object>(null);
            nextTokenVal = null;
            do {
                tokenType = this.hebMorphTokenizer.nextToken(nextToken);
                nextTokenVal = (String)nextToken.ref;
                if (tokenType == 0) {
                    return false;
                }
                if ((tokenType & Tokenizer.TokenType.Hebrew) <= 0 || this.prefixesTree == null) break block12;
            } while ((tokenType & Tokenizer.TokenType.Construct) > 0 && this.isLegalPrefix((String)nextToken.ref));
            if ((tokenType & Tokenizer.TokenType.Acronym) > 0 && (nextTokenVal = (nextToken.ref = this.tryStrippingPrefix((String)nextToken.ref))).indexOf(34) == -1) {
                tokenType &= ~Tokenizer.TokenType.Acronym;
            }
        }
        this.termAtt.copyBuffer(nextTokenVal.toCharArray(), 0, nextTokenVal.length());
        this.offsetAtt.setOffset(this.correctOffset(this.hebMorphTokenizer.getOffset()), this.correctOffset(this.hebMorphTokenizer.getOffset() + this.hebMorphTokenizer.getLengthInSource()));
        this.keywordAtt.setKeyword(true);
        if ((tokenType & Tokenizer.TokenType.Exact) > 0) {
            this.hebTypeAtt.setExact(true);
        }
        if ((tokenType & Tokenizer.TokenType.Hebrew) > 0) {
            if ((tokenType & Tokenizer.TokenType.Acronym) > 0) {
                this.hebTypeAtt.setType(HebrewTokenTypeAttribute.HebrewType.Acronym);
            } else if ((tokenType & Tokenizer.TokenType.Construct) > 0) {
                this.hebTypeAtt.setType(HebrewTokenTypeAttribute.HebrewType.Construct);
            } else {
                this.hebTypeAtt.setType(HebrewTokenTypeAttribute.HebrewType.Hebrew);
            }
        } else if ((tokenType & Tokenizer.TokenType.Numeric) > 0) {
            this.hebTypeAtt.setType(HebrewTokenTypeAttribute.HebrewType.Numeric);
        } else {
            this.hebTypeAtt.setType(HebrewTokenTypeAttribute.HebrewType.NonHebrew);
        }
        return true;
    }

    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.hebMorphTokenizer.getOffset());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void close() throws IOException {
        super.close();
        this.hebMorphTokenizer.reset(this.input);
    }

    public void reset() throws IOException {
        super.reset();
        this.hebMorphTokenizer.reset(this.input);
    }

    public boolean isLegalPrefix(String str) {
        return this.prefixesTree.containsKey(str);
    }

    public String tryStrippingPrefix(String word) {
        int firstQuote = word.indexOf(34);
        if (firstQuote > -1 && firstQuote < word.length() - 2 && this.isLegalPrefix(word.substring(0, firstQuote))) {
            return word.substring(firstQuote + 1, firstQuote + 1 + word.length() - firstQuote - 1);
        }
        int firstSingleQuote = word.indexOf(39);
        if (firstSingleQuote == -1) {
            return word;
        }
        if (firstQuote > -1 && firstSingleQuote > firstQuote) {
            return word;
        }
        if (this.isLegalPrefix(word.substring(0, firstSingleQuote))) {
            return word.substring(firstSingleQuote + 1, firstSingleQuote + 1 + word.length() - firstSingleQuote - 1);
        }
        return word;
    }

    public static interface TOKEN_TYPES {
        public static final int Hebrew = 0;
        public static final int NonHebrew = 1;
        public static final int Numeric = 2;
        public static final int Construct = 3;
        public static final int Acronym = 4;
        public static final int Mixed = 5;
    }
}

