/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hebrew.HebrewTokenizer;
import org.apache.lucene.analysis.hebrew.TokenFilters.NiqqudFilter;

public final class SimpleAnalyzer
extends Analyzer {
    private final CharArraySet commonWords;
    private Map<String, char[]> suffixByTokenType = null;
    private HashMap<String, Integer> prefixesTree;

    public SimpleAnalyzer(HashMap<String, Integer> prefixes) throws IOException {
        this(prefixes, null);
    }

    public SimpleAnalyzer(HashMap<String, Integer> prefixes, CharArraySet commonWords) throws IOException {
        this.commonWords = commonWords;
        this.prefixesTree = prefixes;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        HebrewTokenizer src = new HebrewTokenizer(this.prefixesTree);
        NiqqudFilter tok = new NiqqudFilter((TokenStream)src);
        tok = new LowerCaseFilter((TokenStream)tok);
        return new Analyzer.TokenStreamComponents(src, (TokenStream)tok){

            protected void setReader(Reader reader) {
                super.setReader(reader);
            }
        };
    }

    public void registerSuffix(String tokenType, String suffix) {
        if (this.suffixByTokenType == null) {
            this.suffixByTokenType = new HashMap<String, char[]>();
        }
        if (!this.suffixByTokenType.containsKey(tokenType)) {
            this.suffixByTokenType.put(tokenType, suffix.toCharArray());
        }
    }
}

