/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew;

import com.code972.hebmorph.DescFlag;
import com.code972.hebmorph.HebrewToken;
import com.code972.hebmorph.PrefixType;
import com.code972.hebmorph.Reference;
import com.code972.hebmorph.StreamLemmatizer;
import com.code972.hebmorph.Token;
import com.code972.hebmorph.Tokenizer;
import com.code972.hebmorph.datastructures.DictHebMorph;
import com.code972.hebmorph.datastructures.DictRadix;
import com.code972.hebmorph.lemmafilters.LemmaFilterBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.CharacterUtils;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.hebrew.HebrewTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class StreamLemmasFilter
extends Tokenizer {
    private final StreamLemmatizer _streamLemmatizer;
    private final CharArraySet commonWords;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final LemmaFilterBase lemmaFilter;
    private final List<Token> stack = new ArrayList<Token>();
    private final List<Token> filterCache = new ArrayList<Token>();
    private int index = 0;
    private final Set<String> previousLemmas = new HashSet<String>();
    private boolean keepOriginalWord;
    private final Reference<String> tempRefObject = new Reference<String>("");
    private int currentStartOffset;
    private int currentEndOffset;

    public StreamLemmasFilter(DictHebMorph dict) {
        this(dict, null, null, null);
    }

    public StreamLemmasFilter(DictHebMorph dict, CharArraySet commonWords, LemmaFilterBase lemmaFilter) {
        this(dict, null, commonWords, lemmaFilter);
    }

    public StreamLemmasFilter(DictHebMorph dict, DictRadix<Byte> specialTokenizationCases, CharArraySet commonWords, LemmaFilterBase lemmaFilter) {
        this._streamLemmatizer = new StreamLemmatizer(this.input, dict, specialTokenizationCases);
        this.commonWords = commonWords != null ? commonWords : CharArraySet.EMPTY_SET;
        this.lemmaFilter = lemmaFilter;
    }

    public void setSuffixForExactMatch(Character c) {
        this._streamLemmatizer.setSuffixForExactMatch(c);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        while (this.index < this.stack.size()) {
            HebrewToken res = (HebrewToken)(this.stack.get(this.index) instanceof HebrewToken ? this.stack.get(this.index) : null);
            ++this.index;
            if (res == null || !this.previousLemmas.add(res.getLemma())) continue;
            this.createHebrewToken(res);
            this.offsetAtt.setOffset(this.currentStartOffset, this.currentEndOffset);
            this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(0));
            this.posIncrAtt.setPositionIncrement(0);
            return true;
        }
        this.index = 0;
        this.stack.clear();
        this.previousLemmas.clear();
        int tokenType = this._streamLemmatizer.getLemmatizeNextToken(this.tempRefObject, this.stack);
        if (tokenType == 0) {
            return false;
        }
        this.currentStartOffset = this.correctOffset(this._streamLemmatizer.getStartOffset());
        this.currentEndOffset = this.correctOffset(this._streamLemmatizer.getEndOffset());
        this.offsetAtt.setOffset(this.currentStartOffset, this.currentEndOffset);
        String word = (String)this.tempRefObject.ref;
        if (this.commonWords.contains((CharSequence)word)) {
            this.termAtt.copyBuffer(word.toCharArray(), 0, word.length());
            this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(0));
            this.stack.clear();
            if (!this.keepOriginalWord) {
                if ((tokenType & Tokenizer.TokenType.Exact) > 0) {
                    this.keywordAtt.setKeyword(true);
                }
                return true;
            }
            this.keywordAtt.setKeyword(true);
            if ((tokenType & Tokenizer.TokenType.Exact) == 0) {
                this.stack.add(new HebrewToken(word, 0, DescFlag.D_EMPTY, word, PrefixType.PS_EMPTY, 1.0f));
            }
            return true;
        }
        if ((tokenType & Tokenizer.TokenType.Exact) > 0) {
            this.keywordAtt.setKeyword(true);
        }
        if (this.stack.size() == 1 && !(this.stack.get(0) instanceof HebrewToken)) {
            this.termAtt.copyBuffer(word.toCharArray(), 0, word.length());
            Token tkn = this.stack.get(0);
            if (tkn.isNumeric()) {
                this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(2));
            } else {
                this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(1));
            }
            this.applyLowercaseFilter();
            this.stack.clear();
            return true;
        }
        this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(0));
        if (this.lemmaFilter != null && this.lemmaFilter.filterCollection(word, this.stack, this.filterCache) != null) {
            this.stack.clear();
            this.stack.addAll(this.filterCache);
        }
        if (this.stack.isEmpty()) {
            this.termAtt.copyBuffer(word.toCharArray(), 0, word.length());
            if (this.keepOriginalWord) {
                this.keywordAtt.setKeyword(true);
            }
            if ((tokenType & Tokenizer.TokenType.Mixed) > 0) {
                this.typeAtt.setType(HebrewTokenizer.tokenTypeSignature(5));
                this.applyLowercaseFilter();
                return true;
            }
            if ((tokenType & Tokenizer.TokenType.Exact) > 0) {
                this.applyLowercaseFilter();
                return true;
            }
            if (this.keepOriginalWord) {
                this.stack.add(new HebrewToken(word, 0, DescFlag.D_EMPTY, word, PrefixType.PS_EMPTY, 1.0f));
            }
            return true;
        }
        if (this.keepOriginalWord) {
            this.termAtt.copyBuffer(word.toCharArray(), 0, word.length());
            this.keywordAtt.setKeyword(true);
            return true;
        }
        HebrewToken hebToken = (HebrewToken)this.stack.get(0);
        if (this.stack.size() == 1) {
            this.stack.clear();
        } else {
            this.index = 1;
            this.previousLemmas.add(hebToken.getLemma());
        }
        this.createHebrewToken(hebToken);
        return true;
    }

    private void applyLowercaseFilter() {
        CharacterUtils.toLowerCase((char[])this.termAtt.buffer(), (int)0, (int)this.termAtt.length());
    }

    protected void createHebrewToken(HebrewToken hebToken) {
        String tokenVal = hebToken.getLemma() == null ? hebToken.getText().substring(hebToken.getPrefixLength()) : hebToken.getLemma();
        this.termAtt.copyBuffer(tokenVal.toCharArray(), 0, tokenVal.length());
    }

    public final void end() throws IOException {
        int finalOffset;
        super.end();
        this.currentStartOffset = this.currentEndOffset = (finalOffset = this.correctOffset(this._streamLemmatizer.getEndOffset()));
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void close() throws IOException {
        super.close();
        this.stack.clear();
        this.filterCache.clear();
        this.previousLemmas.clear();
        this.index = 0;
        this._streamLemmatizer.reset(this.input);
    }

    public void reset() throws IOException {
        super.reset();
        this.stack.clear();
        this.filterCache.clear();
        this.previousLemmas.clear();
        this.index = 0;
        this.currentEndOffset = 0;
        this.currentStartOffset = 0;
        this._streamLemmatizer.reset(this.input);
    }

    public void setKeepOriginalWord(boolean keepOriginalWord) {
        this.keepOriginalWord = keepOriginalWord;
    }
}

