/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hebrew.TokenFilters;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hebrew.HebrewTokenTypeAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class AddSuffixTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final HebrewTokenTypeAttribute hebTypeAtt = (HebrewTokenTypeAttribute)this.addAttribute(HebrewTokenTypeAttribute.class);
    private final Character suffix;

    public AddSuffixTokenFilter(TokenStream input, Character suffixToAdd) {
        super(input);
        this.suffix = suffixToAdd;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.hebTypeAtt.isHebrew() || this.hebTypeAtt.getType() == HebrewTokenTypeAttribute.HebrewType.NonHebrew) {
            this.termAtt.append(this.suffix.charValue());
        }
        return true;
    }
}

