/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparsers;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparsers.HebrewQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class HebrewMultiFieldQueryParser
extends MultiFieldQueryParser {
    HebrewMultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(fields, analyzer);
    }

    HebrewMultiFieldQueryParser(String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        super(fields, analyzer, boosts);
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length > flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQueryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            HebrewQueryParser qp = new HebrewQueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQueryBuilder.add(q, flags[i]);
        }
        return bQueryBuilder.build();
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQueryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            HebrewQueryParser qp = new HebrewQueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQueryBuilder.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQueryBuilder.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQueryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            HebrewQueryParser qp = new HebrewQueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQueryBuilder.add(q, flags[i]);
        }
        return bQueryBuilder.build();
    }
}

