/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.security;

import java.rmi.RemoteException;
import org.apache.axis.AxisFault;

public class AuthenticationException
extends RuntimeException {
    private Code code;

    public AuthenticationException(Code code, String details, Throwable throwable) {
        super((Object)((Object)code) + ": " + details, throwable);
        this.code = code;
    }

    public AuthenticationException(Code code) {
        super(code.toString());
        this.code = code;
    }

    public AuthenticationException(RemoteException e) {
        this(AuthenticationException.findCode(e.getMessage()), e instanceof AxisFault ? ((AxisFault)((Object)e)).getFaultDetails()[0].getTextContent() : null, e);
    }

    private static Code findCode(String codeAsString) {
        try {
            int code = Integer.parseInt(codeAsString);
            for (Code c : Code.values()) {
                if (c.code != code) continue;
                return c;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Code.SERVICE_ERROR;
    }

    public Code getCode() {
        return this.code;
    }

    public static enum Code {
        SERVICE_ERROR(100, "Teenuse \u00fcldine veasituatsioon"),
        INVALID_INPUT(101, "Sisendparameetrid mittekorrektsel kujul"),
        MISSING_INPUT(102, "M\u00f5ni kohustuslik sisendparameeter on m\u00e4\u00e4ramata"),
        METHOD_NOT_ALLOWED(103, "Ligip\u00e4\u00e4s antud meetodile antud parameetritega piiratud (n\u00e4iteks kasutatav ServiceName ei ole teenuse pakkuja juures registreeritud)"),
        AUTHENTICATION_ERROR(200, "Teenuse \u00fcldine viga"),
        USER_CERTIFICATE_MISSING(201, "Kasutaja sertifikaat puudub"),
        UNABLE_TO_TEST_USER_CERTIFICATE(202, "Kasutaja sertifikaadi kehtivus ei ole v\u00f5imalik kontrollida"),
        USER_PHONE_ERROR(300, "Kasutajaga telefoniga seotud \u00fcldine viga"),
        NO_AGREEMENT(301, "Kasutajal pole Mobiil-ID lepingut"),
        CERTIFICATE_REVOKED(302, "Kasutaja sertifikaat ei kehti (OCSP vastus REVOKED)."),
        NOT_ACTIVATED(303, "Kasutajal pole Mobiil-ID aktiveeritud. Aktiveerimiseks tuleks minna aadressile http://mobiil.id.ee"),
        NOT_VALID(304, "Toiming on l\u00f5ppenud, kuid kasutaja poolt tekitatud signatuur ei ole kehtiv."),
        USER_AUTHENTICATED(0, "autentimine \u00f5nnestus"),
        OUTSTANDING_TRANSACTION(200, "autentimine alles toimub"),
        EXPIRED_TRANSACTION(0, "Sessioon on aegunud"),
        USER_CANCEL(0, "Kasutaja katkestas"),
        MID_NOT_READY(0, "Mobiil-ID funktsionaalsus ei ole veel kasutatav, proovida m\u00f5ne aja p\u00e4rast uuesti"),
        PHONE_ABSENT(0, "Telefon ei ole levis"),
        SENDING_ERROR(0, "Muu s\u00f5numi saatmise viga (telefon ei suuda s\u00f5numit vastu v\u00f5tta, s\u00f5numikeskus h\u00e4iritud)"),
        SIM_ERROR(0, "SIM rakenduse viga"),
        INTERNAL_ERROR(0, "Teenuse tehniline viga");

        private final int code;
        private final String descriptionInEstonian;

        private Code(int code, String descriptionInEstonian) {
            this.code = code;
            this.descriptionInEstonian = descriptionInEstonian;
        }

        public int getCode() {
            return this.code;
        }
    }
}

