/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.security.mobileid;

import com.codeborne.security.AuthenticationException;
import com.codeborne.security.digidoc.DigiDocServicePortType;
import com.codeborne.security.digidoc.DigiDocService_ServiceLocator;
import com.codeborne.security.mobileid.MobileIDSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.StringHolder;

public class MobileIDAuthenticator {
    private String language = "EST";
    private String serviceName = "Testimine";
    private String loginMessage = "";
    private int retryCount = 60;
    private int pollIntervalMs = 3000;
    private final String messagingMode = "asynchClientServer";
    DigiDocServicePortType service;

    public MobileIDAuthenticator() {
    }

    public MobileIDAuthenticator(String digidocServiceURL) {
        this.setDigidocServiceURL(digidocServiceURL);
    }

    public MobileIDAuthenticator(String digidocServiceURL, String serviceName) {
        this.setDigidocServiceURL(digidocServiceURL);
        this.serviceName = serviceName;
    }

    public MobileIDAuthenticator(URL digidocServiceURL) {
        this.setDigidocServiceURL(digidocServiceURL);
    }

    public MobileIDAuthenticator(URL digidocServiceURL, String serviceName) {
        this.setDigidocServiceURL(digidocServiceURL);
        this.serviceName = serviceName;
    }

    public final MobileIDAuthenticator setDigidocServiceURL(String digidocServiceURL) {
        try {
            return this.setDigidocServiceURL(new URL(digidocServiceURL));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public final MobileIDAuthenticator setDigidocServiceURL(URL digidocServiceURL) {
        DigiDocService_ServiceLocator digiDocService = new DigiDocService_ServiceLocator();
        try {
            this.service = digiDocService.getDigiDocService(digidocServiceURL);
        }
        catch (ServiceException e) {
            throw new RuntimeException("Failed to initialize Mobile-ID support", e);
        }
        return this;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setLoginMessage(String loginMessage) {
        this.loginMessage = loginMessage;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setPollIntervalMs(int pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public MobileIDSession startLogin(String personalCode, String countryCode) {
        return this.startLogin(personalCode, countryCode, null);
    }

    public MobileIDSession startLogin(String phone) {
        return this.startLogin(null, null, phone);
    }

    protected MobileIDSession startLogin(String personalCode, String countryCode, String phone) {
        if (this.service == null) {
            throw new IllegalStateException("digidocServiceURL is not initialized");
        }
        IntHolder sessCode = new IntHolder();
        StringHolder result = new StringHolder();
        StringHolder firstName = new StringHolder();
        StringHolder lastName = new StringHolder();
        StringHolder personalCodeHolder = new StringHolder();
        StringHolder challenge = new StringHolder();
        try {
            this.service.mobileAuthenticate(personalCode, countryCode, this.normalizePhoneNumber(phone), this.language, this.serviceName, this.loginMessage, this.generateSPChallenge(), "asynchClientServer", 0, false, false, sessCode, result, personalCodeHolder, firstName, lastName, new StringHolder(), new StringHolder(), new StringHolder(), challenge, new StringHolder(), new StringHolder());
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e);
        }
        if (!"OK".equals(result.value)) {
            throw new AuthenticationException(AuthenticationException.Code.valueOf(result.value));
        }
        return new MobileIDSession(sessCode.value, challenge.value, firstName.value, lastName.value, personalCodeHolder.value);
    }

    String normalizePhoneNumber(String phone) {
        return phone != null && phone.startsWith("+") ? phone.substring(1) : phone;
    }

    protected String generateSPChallenge() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            sb.append((int)(Math.random() * 10.0));
        }
        return sb.toString();
    }

    public MobileIDSession waitForLogin(MobileIDSession session) {
        int tryCount;
        for (tryCount = 0; this.sleep(this.pollIntervalMs) && !this.isLoginComplete(session) && tryCount < this.retryCount; ++tryCount) {
        }
        if (tryCount >= this.retryCount) {
            throw new AuthenticationException(AuthenticationException.Code.valueOf(this.getLoginStatus((MobileIDSession)session).value));
        }
        return session;
    }

    public boolean isLoginComplete(MobileIDSession session) {
        StringHolder status = this.getLoginStatus(session);
        if ("OUTSTANDING_TRANSACTION".equals(status.value)) {
            return false;
        }
        if ("USER_AUTHENTICATED".equals(status.value)) {
            return true;
        }
        throw new AuthenticationException(AuthenticationException.Code.valueOf(status.value));
    }

    private StringHolder getLoginStatus(MobileIDSession session) {
        StringHolder status = new StringHolder("OUTSTANDING_TRANSACTION");
        try {
            this.service.getMobileAuthenticateStatus(session.sessCode, false, status, new StringHolder());
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e);
        }
        return status;
    }

    boolean sleep(int sleepTimeMilliseconds) {
        try {
            Thread.sleep(sleepTimeMilliseconds);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

