/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.security.mobileid;

import java.io.Serializable;

public class MobileIDSession
implements Serializable {
    public final String firstName;
    public final String lastName;
    public final String personalCode;
    public final String challenge;
    public final int sessCode;

    public MobileIDSession(int sessCode, String challenge, String firstName, String lastName, String personalCode) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.personalCode = personalCode;
        this.challenge = challenge;
        this.sessCode = sessCode;
    }

    public String getFullName() {
        return this.firstName + "\u00a0" + this.lastName;
    }

    public String toString() {
        return this.sessCode + ":::" + this.challenge + ":::" + this.firstName + ":::" + this.lastName + ":::" + this.personalCode;
    }

    public static MobileIDSession fromString(String serializedMobileIDSession) {
        String[] tokens = serializedMobileIDSession.split(":::");
        return new MobileIDSession(Integer.parseInt(tokens[0]), tokens[1], tokens[2], tokens[3], tokens[4]);
    }
}

