/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.security.mobileid.test;

import com.codeborne.security.AuthenticationException;
import com.codeborne.security.mobileid.MobileIDAuthenticator;
import com.codeborne.security.mobileid.MobileIDSession;

public class MobileIDAuthenticatorStub
extends MobileIDAuthenticator {
    public long loginTimeMs = 1000L;
    public String firstName = "T\u00f5nis";
    public String lastName = "J\u00e4\u00e4gup";
    public String personalCode = "37259180809";

    public MobileIDAuthenticatorStub() {
    }

    public MobileIDAuthenticatorStub(long loginTimeMs, String firstName, String lastName) {
        this.loginTimeMs = loginTimeMs;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    protected MobileIDSession startLogin(String personalCode, String countryCode, String phone) {
        if (phone == null || phone.length() < 5) {
            throw new AuthenticationException(AuthenticationException.Code.INVALID_INPUT, "Invalid PhoneNo", null);
        }
        if (phone.startsWith("+37255")) {
            throw new AuthenticationException(AuthenticationException.Code.NO_AGREEMENT, "User is not a Mobile-ID client", null);
        }
        return new MobileIDSession(Integer.parseInt(phone.replaceFirst("\\+372(.*)", "$1")), "1234", this.firstName, this.lastName, personalCode == null ? this.personalCode : personalCode);
    }

    @Override
    public MobileIDSession waitForLogin(MobileIDSession session) {
        String phone = "+372" + session.sessCode;
        if (phone.startsWith("+37256")) {
            throw new AuthenticationException(AuthenticationException.Code.USER_CANCEL);
        }
        try {
            Thread.sleep(this.loginTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return session;
    }
}

