/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.matchers;

import com.codeborne.pdftest.PDF;
import com.codeborne.pdftest.matchers.PDFMatcher;
import java.util.Arrays;
import org.hamcrest.Description;

public class DoesNotContainText
extends PDFMatcher {
    private final String text;
    private final String[] texts;

    public DoesNotContainText(String text, String ... texts) {
        this.text = text;
        this.texts = texts;
    }

    protected boolean matchesSafely(PDF item) {
        String reducedPdfText = this.reduceSpaces(item.text);
        return !reducedPdfText.contains(this.reduceSpaces(this.text)) && Arrays.stream(this.texts).noneMatch(str -> reducedPdfText.contains(this.reduceSpaces((String)str)));
    }

    protected void describeMismatchSafely(PDF item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(this.reduceSpaces(item.text)).appendText("\"");
    }

    public void describeTo(Description description) {
        description.appendText("a PDF not containing ");
        this.buildErrorMessage(description, this.text, this.texts);
    }
}

