/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.assertj;

import com.codeborne.pdftest.PDF;
import com.codeborne.pdftest.Spaces;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Strings;

public class PdfAssert
extends AbstractAssert<PdfAssert, PDF> {
    private final Strings strings = Strings.instance();

    public PdfAssert(PDF actual) {
        super((Object)actual, PdfAssert.class);
    }

    public PdfAssert containsText(String text, String ... texts) {
        this.isNotNull();
        this.strings.assertContains((AssertionInfo)this.info, (CharSequence)Spaces.reduce(((PDF)this.actual).text), (CharSequence[])Spaces.reduce(text, texts));
        return this;
    }

    public PdfAssert doesNotContainText(String text, String ... texts) {
        this.isNotNull();
        this.strings.assertDoesNotContain((AssertionInfo)this.info, (CharSequence)Spaces.reduce(((PDF)this.actual).text), (CharSequence[])Spaces.reduce(text, texts));
        return this;
    }

    public PdfAssert containsExactText(String substring) {
        this.isNotNull();
        this.strings.assertContains((AssertionInfo)this.info, (CharSequence)((PDF)this.actual).text, new CharSequence[]{substring});
        return this;
    }

    public PdfAssert doesNotContainExactText(String substring) {
        this.isNotNull();
        this.strings.assertDoesNotContain((AssertionInfo)this.info, (CharSequence)((PDF)this.actual).text, new CharSequence[]{substring});
        return this;
    }

    public PdfAssert containsTextCaseInsensitive(String substring) {
        this.isNotNull();
        this.strings.assertContainsIgnoringCase((AssertionInfo)this.info, (CharSequence)Spaces.reduce(((PDF)this.actual).text), (CharSequence)Spaces.reduce(substring));
        return this;
    }

    public PdfAssert matchesText(String regex) {
        return this.matchesText(Pattern.compile(regex));
    }

    public PdfAssert matchesText(Pattern regex) {
        this.isNotNull();
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)Spaces.reduce(((PDF)this.actual).text), regex);
        return this;
    }
}

