/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.matchers;

import com.codeborne.pdftest.PDF;
import com.codeborne.pdftest.Spaces;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

abstract class PDFMatcher
extends TypeSafeMatcher<PDF>
implements SelfDescribing {
    PDFMatcher() {
    }

    protected String reduceSpaces(String text) {
        return Spaces.reduce(text);
    }

    protected void buildErrorMessage(Description description, String text, String[] texts) {
        if (texts.length > 0) {
            List reducedStrings = Arrays.stream(texts).map(Spaces::reduce).collect(Collectors.toList());
            reducedStrings.add(0, this.reduceSpaces(text));
            description.appendValueList("", ", ", "", reducedStrings);
        } else {
            description.appendValue((Object)this.reduceSpaces(text));
        }
    }
}

