/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdfest.matchers;

import com.codeborne.pdfest.PDF;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class PDFContainsString
extends TypeSafeMatcher<PDF>
implements SelfDescribing {
    private final String substring;

    public PDFContainsString(String substring) {
        this.substring = substring;
    }

    protected boolean matchesSafely(PDF item) {
        return item.text.contains(this.substring);
    }

    protected void describeMismatchSafely(PDF item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(item.text).appendText("\"");
    }

    public void describeTo(Description description) {
        description.appendText("a PDF containing ").appendValue((Object)this.substring);
    }
}

