/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.impl.SelenidePageFactory;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.HasSessionDetails;
import io.appium.java_client.MobileElement;
import io.appium.java_client.pagefactory.AppiumFieldDecorator;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ByIdOrName;

@ParametersAreNonnullByDefault
public class SelenideAppiumPageFactory
extends SelenidePageFactory {
    @Nonnull
    protected By findSelector(Driver driver, Field field) {
        DefaultElementByBuilder builder = this.byBuilder(driver);
        builder.setAnnotated((AnnotatedElement)field);
        By selector = builder.buildBy();
        return selector != null ? selector : super.findSelector(driver, field);
    }

    private DefaultElementByBuilder byBuilder(Driver driver) {
        if (!HasSessionDetails.class.isAssignableFrom(driver.getWebDriver().getClass())) {
            return new DefaultElementByBuilder(null, null);
        }
        HasSessionDetails d = (HasSessionDetails)driver.getWebDriver();
        return new DefaultElementByBuilder(d.getPlatformName(), d.getAutomationName());
    }

    @CheckReturnValue
    @Nullable
    public Object decorate(ClassLoader loader, Driver driver, WebElementSource searchContext, Field field, By selector, Type[] genericTypes) {
        if (selector instanceof ByIdOrName) {
            return this.decorateWithAppium(loader, searchContext, field);
        }
        return super.decorate(loader, driver, searchContext, field, selector, genericTypes);
    }

    private Object decorateWithAppium(ClassLoader loader, WebElementSource searchContext, Field field) {
        AppiumFieldDecorator defaultAppiumFieldDecorator = new AppiumFieldDecorator((SearchContext)searchContext.getWebElement());
        Object appiumElement = defaultAppiumFieldDecorator.decorate(loader, field);
        if (appiumElement instanceof MobileElement) {
            return Selenide.$((WebElement)((MobileElement)appiumElement));
        }
        return appiumElement;
    }
}

