/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Driver;
import io.appium.java_client.clipboard.HasClipboard;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppiumClipboard
implements Clipboard {
    private final Driver driver;

    public AppiumClipboard(Driver driver) {
        this.driver = driver;
    }

    @Nonnull
    @CheckReturnValue
    public Driver driver() {
        return this.driver;
    }

    @Nonnull
    @CheckReturnValue
    public Clipboard object() {
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public String getText() {
        return this.getWebDriver().getClipboardText();
    }

    public void setText(String text) {
        this.getWebDriver().setClipboardText(text);
    }

    private HasClipboard getWebDriver() {
        return (HasClipboard)this.driver.getWebDriver();
    }
}

