/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.ElementDescriber;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AppiumElementDescriber
implements ElementDescriber {
    private static final Logger logger = LoggerFactory.getLogger(AppiumElementDescriber.class);
    private static final Pattern RE_IOS_UNSUPPORTED_ATTRIBUTE = Pattern.compile(".*The attribute '\\w+' is unknown.*", 32);

    @Nonnull
    public String fully(Driver driver, @Nullable WebElement element) {
        if (element == null) {
            return "null";
        }
        return new Builder(element).appendTagName().appendAttributes(this.supportedAttributes(driver)).finish().build();
    }

    protected List<String> supportedAttributes(Driver driver) {
        if (driver.getWebDriver() instanceof AndroidDriver) {
            return this.androidAttributes();
        }
        if (driver.getWebDriver() instanceof IOSDriver) {
            return this.iosAttributes();
        }
        return this.genericAttributes();
    }

    protected List<String> androidAttributes() {
        return Arrays.asList("resource-id", "checked", "content-desc", "enabled", "focused", "package", "name", "className", "bounds", "displayed");
    }

    protected List<String> iosAttributes() {
        return Arrays.asList("enabled", "selected", "name", "type", "value", "visible");
    }

    protected List<String> genericAttributes() {
        return Arrays.asList("checked", "content-desc", "enabled", "name", "displayed");
    }

    @Nonnull
    public String briefly(Driver driver, @Nonnull WebElement element) {
        return new Builder(element).appendTagName().appendAttribute("resource-id").finish().build();
    }

    @CheckReturnValue
    @Nonnull
    public String selector(By selector) {
        if (selector instanceof By.ByCssSelector) {
            return selector.toString().replace("By.selector: ", "").replace("By.cssSelector: ", "");
        }
        return selector.toString();
    }

    static boolean isUnsupportedAttributeError(WebDriverException e) {
        return e instanceof UnsupportedCommandException || RE_IOS_UNSUPPORTED_ATTRIBUTE.matcher(e.getMessage()).matches();
    }

    @ParametersAreNonnullByDefault
    private static class Builder {
        private final WebElement element;
        private String className = "?";
        private String tagName = "?";
        private String text = "?";
        private final StringBuilder sb = new StringBuilder();
        private StaleElementReferenceException staleElementException;

        private Builder(WebElement element) {
            this.element = element;
        }

        private Builder appendTagName() {
            this.getAttribute("class", className -> {
                this.className = className;
                this.tagName = className.replaceFirst(".+\\.(.+)", "$1");
            });
            if ("?".equals(this.tagName)) {
                this.safeCall(() -> ((WebElement)this.element).getTagName(), () -> "Failed to get tag name", tagName -> {
                    this.tagName = tagName;
                });
            }
            this.sb.append("<").append(this.tagName).append(" class=\"").append(this.className).append("\"");
            return this;
        }

        private Builder appendAttributes(List<String> names) {
            names.forEach(this::appendAttribute);
            return this;
        }

        private Builder appendAttribute(String name) {
            this.getAttribute(name, value -> this.sb.append(" ").append(name).append("=\"").append((String)value).append("\""));
            return this;
        }

        private void getAttribute(String name, Consumer<String> attributeHandler) {
            this.safeCall(() -> this.element.getAttribute(name), () -> "Failed to get attribute " + name, attributeHandler);
        }

        private void safeCall(Supplier<String> method, Supplier<String> errorMessage, Consumer<String> resultHandler) {
            if (this.staleElementException != null) {
                return;
            }
            try {
                String value = method.get();
                if (value != null) {
                    resultHandler.accept(value);
                }
            }
            catch (StaleElementReferenceException e) {
                this.staleElementException = e;
                logger.debug("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
            }
            catch (WebDriverException e) {
                if (AppiumElementDescriber.isUnsupportedAttributeError(e)) {
                    logger.debug("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
                } else {
                    logger.info("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
                }
            }
            catch (RuntimeException e) {
                logger.warn("{}", (Object)errorMessage.get(), (Object)e);
            }
        }

        public Builder finish() {
            this.sb.append(">");
            if (this.staleElementException != null) {
                this.sb.append((Object)this.staleElementException);
            } else {
                this.appendText();
            }
            this.sb.append("</").append(this.tagName).append(">");
            return this;
        }

        private void appendText() {
            this.safeCall(() -> ((WebElement)this.element).getText(), () -> "Failed to get text", text -> {
                this.text = text;
            });
            if ("?".equals(this.text)) {
                this.getAttribute("text", text -> {
                    this.text = text;
                });
            }
            if ("?".equals(this.text)) {
                this.getAttribute("label", text -> {
                    this.text = text;
                });
            }
            if ("?".equals(this.text)) {
                this.getAttribute("value", text -> {
                    this.text = text;
                });
            }
            this.sb.append(this.text);
        }

        private String build() {
            return this.sb.toString();
        }
    }
}

