/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class AppiumNavigator {
    public void launchApp(Supplier<Runnable> driverSupplier) {
        Configuration.browserSize = null;
        Configuration.pageLoadTimeout = 0L;
        SelenideLogger.run((String)"launch app", (String)"", (Runnable)driverSupplier.get());
    }

    public void terminateApp(AppiumDriver driver, String appId) {
        SelenideLogger.run((String)"terminate app", (String)appId, () -> {
            HashMap<String, String> params = new HashMap<String, String>();
            if (WebdriverUnwrapper.instanceOf((WebDriver)driver, AndroidDriver.class)) {
                params.put("appId", appId);
            } else if (WebdriverUnwrapper.instanceOf((WebDriver)driver, IOSDriver.class)) {
                params.put("bundleId", appId);
            } else {
                throw new IllegalArgumentException("Cannot terminate application for unknown driver " + driver.getClass());
            }
            driver.executeScript("mobile:terminateApp", new Object[]{params});
        });
    }
}

